package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotsResponse(
    snapshots: Optional[Iterable[zio.aws.fsx.model.Snapshot]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse = {
    import DescribeSnapshotsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse
      .builder()
      .optionallyWith(
        snapshots.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.snapshots)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeSnapshotsResponse.ReadOnly =
    zio.aws.fsx.model.DescribeSnapshotsResponse.wrap(buildAwsValue())
}
object DescribeSnapshotsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeSnapshotsResponse =
      zio.aws.fsx.model.DescribeSnapshotsResponse(
        snapshots.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def snapshots: Optional[List[zio.aws.fsx.model.Snapshot.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getSnapshots
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Snapshot.ReadOnly]] =
      AwsError.unwrapOptionField("snapshots", snapshots)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse
  ) extends zio.aws.fsx.model.DescribeSnapshotsResponse.ReadOnly {
    override val snapshots
        : Optional[List[zio.aws.fsx.model.Snapshot.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshots())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Snapshot.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeSnapshotsResponse
  ): zio.aws.fsx.model.DescribeSnapshotsResponse.ReadOnly = new Wrapper(impl)
}
