package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  NextToken,
  MaxResults,
  StorageVirtualMachineId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeStorageVirtualMachinesRequest(
    storageVirtualMachineIds: Optional[Iterable[StorageVirtualMachineId]] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.fsx.model.StorageVirtualMachineFilter]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest = {
    import DescribeStorageVirtualMachinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest
      .builder()
      .optionallyWith(
        storageVirtualMachineIds.map(value =>
          value.map { item =>
            StorageVirtualMachineId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.storageVirtualMachineIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest.ReadOnly =
    zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest
      .wrap(buildAwsValue())
}
object DescribeStorageVirtualMachinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest =
      zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest(
        storageVirtualMachineIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def storageVirtualMachineIds: Optional[List[StorageVirtualMachineId]]
    def filters
        : Optional[List[zio.aws.fsx.model.StorageVirtualMachineFilter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getStorageVirtualMachineIds
        : ZIO[Any, AwsError, List[StorageVirtualMachineId]] = AwsError
      .unwrapOptionField("storageVirtualMachineIds", storageVirtualMachineIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.StorageVirtualMachineFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest
  ) extends zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest.ReadOnly {
    override val storageVirtualMachineIds
        : Optional[List[StorageVirtualMachineId]] = zio.aws.core.internal
      .optionalFromNullable(impl.storageVirtualMachineIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.StorageVirtualMachineId(item)
        }.toList
      )
    override val filters: Optional[
      List[zio.aws.fsx.model.StorageVirtualMachineFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.StorageVirtualMachineFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesRequest
  ): zio.aws.fsx.model.DescribeStorageVirtualMachinesRequest.ReadOnly =
    new Wrapper(impl)
}
