package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeStorageVirtualMachinesResponse(
    storageVirtualMachines: Optional[
      Iterable[zio.aws.fsx.model.StorageVirtualMachine]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse = {
    import DescribeStorageVirtualMachinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse
      .builder()
      .optionallyWith(
        storageVirtualMachines.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageVirtualMachines)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse.ReadOnly =
    zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse
      .wrap(buildAwsValue())
}
object DescribeStorageVirtualMachinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse =
      zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse(
        storageVirtualMachines.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def storageVirtualMachines
        : Optional[List[zio.aws.fsx.model.StorageVirtualMachine.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getStorageVirtualMachines: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.StorageVirtualMachine.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "storageVirtualMachines",
      storageVirtualMachines
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse
  ) extends zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse.ReadOnly {
    override val storageVirtualMachines
        : Optional[List[zio.aws.fsx.model.StorageVirtualMachine.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageVirtualMachines())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.StorageVirtualMachine.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeStorageVirtualMachinesResponse
  ): zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse.ReadOnly =
    new Wrapper(impl)
}
