package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.NextToken
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeVolumesResponse(
    volumes: Optional[Iterable[zio.aws.fsx.model.Volume]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse = {
    import DescribeVolumesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse
      .builder()
      .optionallyWith(
        volumes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.volumes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeVolumesResponse.ReadOnly =
    zio.aws.fsx.model.DescribeVolumesResponse.wrap(buildAwsValue())
}
object DescribeVolumesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeVolumesResponse =
      zio.aws.fsx.model.DescribeVolumesResponse(
        volumes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def volumes: Optional[List[zio.aws.fsx.model.Volume.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getVolumes
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Volume.ReadOnly]] =
      AwsError.unwrapOptionField("volumes", volumes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse
  ) extends zio.aws.fsx.model.DescribeVolumesResponse.ReadOnly {
    override val volumes: Optional[List[zio.aws.fsx.model.Volume.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Volume.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeVolumesResponse
  ): zio.aws.fsx.model.DescribeVolumesResponse.ReadOnly = new Wrapper(impl)
}
