package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.Iops
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DiskIopsConfiguration(
    mode: Optional[zio.aws.fsx.model.DiskIopsConfigurationMode] =
      Optional.Absent,
    iops: Optional[Iops] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration = {
    import DiskIopsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(iops.map(value => Iops.unwrap(value): java.lang.Long))(
        _.iops
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly =
    zio.aws.fsx.model.DiskIopsConfiguration.wrap(buildAwsValue())
}
object DiskIopsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DiskIopsConfiguration = zio.aws.fsx.model
      .DiskIopsConfiguration(mode.map(value => value), iops.map(value => value))
    def mode: Optional[zio.aws.fsx.model.DiskIopsConfigurationMode]
    def iops: Optional[Iops]
    def getMode
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfigurationMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getIops: ZIO[Any, AwsError, Iops] =
      AwsError.unwrapOptionField("iops", iops)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration
  ) extends zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly {
    override val mode: Optional[zio.aws.fsx.model.DiskIopsConfigurationMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.fsx.model.DiskIopsConfigurationMode.wrap(value))
    override val iops: Optional[Iops] = zio.aws.core.internal
      .optionalFromNullable(impl.iops())
      .map(value => zio.aws.fsx.model.primitives.Iops(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DiskIopsConfiguration
  ): zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly = new Wrapper(impl)
}
