package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait DriveCacheType {
  def unwrap: software.amazon.awssdk.services.fsx.model.DriveCacheType
}
object DriveCacheType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.DriveCacheType
  ): zio.aws.fsx.model.DriveCacheType = value match {
    case software.amazon.awssdk.services.fsx.model.DriveCacheType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.DriveCacheType.NONE =>
      val r = NONE
      r
    case software.amazon.awssdk.services.fsx.model.DriveCacheType.READ =>
      val r = READ
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.DriveCacheType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DriveCacheType =
      software.amazon.awssdk.services.fsx.model.DriveCacheType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE extends zio.aws.fsx.model.DriveCacheType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DriveCacheType =
      software.amazon.awssdk.services.fsx.model.DriveCacheType.NONE
  }
  case object READ extends zio.aws.fsx.model.DriveCacheType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DriveCacheType =
      software.amazon.awssdk.services.fsx.model.DriveCacheType.READ
  }
}
