package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait EventType {
  def unwrap: software.amazon.awssdk.services.fsx.model.EventType
}
object EventType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.EventType
  ): zio.aws.fsx.model.EventType = value match {
    case software.amazon.awssdk.services.fsx.model.EventType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.EventType.NEW =>
      val r = NEW
      r
    case software.amazon.awssdk.services.fsx.model.EventType.CHANGED =>
      val r = CHANGED
      r
    case software.amazon.awssdk.services.fsx.model.EventType.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.EventType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.EventType =
      software.amazon.awssdk.services.fsx.model.EventType.UNKNOWN_TO_SDK_VERSION
  }
  case object NEW extends zio.aws.fsx.model.EventType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.EventType =
      software.amazon.awssdk.services.fsx.model.EventType.NEW
  }
  case object CHANGED extends zio.aws.fsx.model.EventType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.EventType =
      software.amazon.awssdk.services.fsx.model.EventType.CHANGED
  }
  case object DELETED extends zio.aws.fsx.model.EventType {
    override def unwrap: software.amazon.awssdk.services.fsx.model.EventType =
      software.amazon.awssdk.services.fsx.model.EventType.DELETED
  }
}
