package zio.aws.fsx.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  SubnetId,
  VpcId,
  CreationTime,
  DNSName,
  NetworkInterfaceId,
  FileSystemTypeVersion,
  StorageCapacity,
  FileSystemId,
  AWSAccountId,
  ResourceARN,
  KmsKeyId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class FileSystem(
    ownerId: Optional[AWSAccountId] = Optional.Absent,
    creationTime: Optional[CreationTime] = Optional.Absent,
    fileSystemId: Optional[FileSystemId] = Optional.Absent,
    fileSystemType: Optional[zio.aws.fsx.model.FileSystemType] =
      Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.FileSystemLifecycle] =
      Optional.Absent,
    failureDetails: Optional[zio.aws.fsx.model.FileSystemFailureDetails] =
      Optional.Absent,
    storageCapacity: Optional[StorageCapacity] = Optional.Absent,
    storageType: Optional[zio.aws.fsx.model.StorageType] = Optional.Absent,
    vpcId: Optional[VpcId] = Optional.Absent,
    subnetIds: Optional[Iterable[SubnetId]] = Optional.Absent,
    networkInterfaceIds: Optional[Iterable[NetworkInterfaceId]] =
      Optional.Absent,
    dnsName: Optional[DNSName] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    resourceARN: Optional[ResourceARN] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    windowsConfiguration: Optional[
      zio.aws.fsx.model.WindowsFileSystemConfiguration
    ] = Optional.Absent,
    lustreConfiguration: Optional[
      zio.aws.fsx.model.LustreFileSystemConfiguration
    ] = Optional.Absent,
    administrativeActions: Optional[
      Iterable[zio.aws.fsx.model.AdministrativeAction]
    ] = Optional.Absent,
    ontapConfiguration: Optional[
      zio.aws.fsx.model.OntapFileSystemConfiguration
    ] = Optional.Absent,
    fileSystemTypeVersion: Optional[FileSystemTypeVersion] = Optional.Absent,
    openZFSConfiguration: Optional[
      zio.aws.fsx.model.OpenZFSFileSystemConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.FileSystem = {
    import FileSystem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileSystem
      .builder()
      .optionallyWith(
        ownerId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .optionallyWith(
        creationTime.map(value => CreationTime.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        fileSystemId.map(value => FileSystemId.unwrap(value): java.lang.String)
      )(_.fileSystemId)
      .optionallyWith(fileSystemType.map(value => value.unwrap))(
        _.fileSystemType
      )
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .optionallyWith(
        storageCapacity.map(value => StorageCapacity.unwrap(value): Integer)
      )(_.storageCapacity)
      .optionallyWith(storageType.map(value => value.unwrap))(_.storageType)
      .optionallyWith(
        vpcId.map(value => VpcId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        subnetIds.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnetIds)
      .optionallyWith(
        networkInterfaceIds.map(value =>
          value.map { item =>
            NetworkInterfaceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.networkInterfaceIds)
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(
        resourceARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.resourceARN)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(windowsConfiguration.map(value => value.buildAwsValue()))(
        _.windowsConfiguration
      )
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .optionallyWith(
        administrativeActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.administrativeActions)
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(
        fileSystemTypeVersion.map(value =>
          FileSystemTypeVersion.unwrap(value): java.lang.String
        )
      )(_.fileSystemTypeVersion)
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.FileSystem.ReadOnly =
    zio.aws.fsx.model.FileSystem.wrap(buildAwsValue())
}
object FileSystem {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.FileSystem] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileSystem = zio.aws.fsx.model.FileSystem(
      ownerId.map(value => value),
      creationTime.map(value => value),
      fileSystemId.map(value => value),
      fileSystemType.map(value => value),
      lifecycle.map(value => value),
      failureDetails.map(value => value.asEditable),
      storageCapacity.map(value => value),
      storageType.map(value => value),
      vpcId.map(value => value),
      subnetIds.map(value => value),
      networkInterfaceIds.map(value => value),
      dnsName.map(value => value),
      kmsKeyId.map(value => value),
      resourceARN.map(value => value),
      tags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      windowsConfiguration.map(value => value.asEditable),
      lustreConfiguration.map(value => value.asEditable),
      administrativeActions.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      ontapConfiguration.map(value => value.asEditable),
      fileSystemTypeVersion.map(value => value),
      openZFSConfiguration.map(value => value.asEditable)
    )
    def ownerId: Optional[AWSAccountId]
    def creationTime: Optional[CreationTime]
    def fileSystemId: Optional[FileSystemId]
    def fileSystemType: Optional[zio.aws.fsx.model.FileSystemType]
    def lifecycle: Optional[zio.aws.fsx.model.FileSystemLifecycle]
    def failureDetails
        : Optional[zio.aws.fsx.model.FileSystemFailureDetails.ReadOnly]
    def storageCapacity: Optional[StorageCapacity]
    def storageType: Optional[zio.aws.fsx.model.StorageType]
    def vpcId: Optional[VpcId]
    def subnetIds: Optional[List[SubnetId]]
    def networkInterfaceIds: Optional[List[NetworkInterfaceId]]
    def dnsName: Optional[DNSName]
    def kmsKeyId: Optional[KmsKeyId]
    def resourceARN: Optional[ResourceARN]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def windowsConfiguration
        : Optional[zio.aws.fsx.model.WindowsFileSystemConfiguration.ReadOnly]
    def lustreConfiguration
        : Optional[zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly]
    def administrativeActions
        : Optional[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]]
    def ontapConfiguration
        : Optional[zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly]
    def fileSystemTypeVersion: Optional[FileSystemTypeVersion]
    def openZFSConfiguration
        : Optional[zio.aws.fsx.model.OpenZFSFileSystemConfiguration.ReadOnly]
    def getOwnerId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getCreationTime: ZIO[Any, AwsError, CreationTime] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getFileSystemId: ZIO[Any, AwsError, FileSystemId] =
      AwsError.unwrapOptionField("fileSystemId", fileSystemId)
    def getFileSystemType
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemType] =
      AwsError.unwrapOptionField("fileSystemType", fileSystemType)
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getFailureDetails: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.FileSystemFailureDetails.ReadOnly
    ] = AwsError.unwrapOptionField("failureDetails", failureDetails)
    def getStorageCapacity: ZIO[Any, AwsError, StorageCapacity] =
      AwsError.unwrapOptionField("storageCapacity", storageCapacity)
    def getStorageType: ZIO[Any, AwsError, zio.aws.fsx.model.StorageType] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getVpcId: ZIO[Any, AwsError, VpcId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getSubnetIds: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnetIds", subnetIds)
    def getNetworkInterfaceIds: ZIO[Any, AwsError, List[NetworkInterfaceId]] =
      AwsError.unwrapOptionField("networkInterfaceIds", networkInterfaceIds)
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getResourceARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("resourceARN", resourceARN)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getWindowsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.WindowsFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("windowsConfiguration", windowsConfiguration)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
    def getAdministrativeActions: ZIO[Any, AwsError, List[
      zio.aws.fsx.model.AdministrativeAction.ReadOnly
    ]] =
      AwsError.unwrapOptionField("administrativeActions", administrativeActions)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getFileSystemTypeVersion: ZIO[Any, AwsError, FileSystemTypeVersion] =
      AwsError.unwrapOptionField("fileSystemTypeVersion", fileSystemTypeVersion)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.OpenZFSFileSystemConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileSystem
  ) extends zio.aws.fsx.model.FileSystem.ReadOnly {
    override val ownerId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.fsx.model.primitives.AWSAccountId(value))
    override val creationTime: Optional[CreationTime] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.fsx.model.primitives.CreationTime(value))
    override val fileSystemId: Optional[FileSystemId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemId())
      .map(value => zio.aws.fsx.model.primitives.FileSystemId(value))
    override val fileSystemType: Optional[zio.aws.fsx.model.FileSystemType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemType())
        .map(value => zio.aws.fsx.model.FileSystemType.wrap(value))
    override val lifecycle: Optional[zio.aws.fsx.model.FileSystemLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.FileSystemLifecycle.wrap(value))
    override val failureDetails
        : Optional[zio.aws.fsx.model.FileSystemFailureDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureDetails())
        .map(value => zio.aws.fsx.model.FileSystemFailureDetails.wrap(value))
    override val storageCapacity: Optional[StorageCapacity] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageCapacity())
        .map(value => zio.aws.fsx.model.primitives.StorageCapacity(value))
    override val storageType: Optional[zio.aws.fsx.model.StorageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageType())
        .map(value => zio.aws.fsx.model.StorageType.wrap(value))
    override val vpcId: Optional[VpcId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.fsx.model.primitives.VpcId(value))
    override val subnetIds: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnetIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.SubnetId(item)
        }.toList
      )
    override val networkInterfaceIds: Optional[List[NetworkInterfaceId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkInterfaceIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.NetworkInterfaceId(item)
          }.toList
        )
    override val dnsName: Optional[DNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value => zio.aws.fsx.model.primitives.DNSName(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.fsx.model.primitives.KmsKeyId(value))
    override val resourceARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val windowsConfiguration
        : Optional[zio.aws.fsx.model.WindowsFileSystemConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowsConfiguration())
        .map(value =>
          zio.aws.fsx.model.WindowsFileSystemConfiguration.wrap(value)
        )
    override val lustreConfiguration
        : Optional[zio.aws.fsx.model.LustreFileSystemConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lustreConfiguration())
        .map(value =>
          zio.aws.fsx.model.LustreFileSystemConfiguration.wrap(value)
        )
    override val administrativeActions
        : Optional[List[zio.aws.fsx.model.AdministrativeAction.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.administrativeActions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.AdministrativeAction.wrap(item)
          }.toList
        )
    override val ontapConfiguration
        : Optional[zio.aws.fsx.model.OntapFileSystemConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ontapConfiguration())
        .map(value =>
          zio.aws.fsx.model.OntapFileSystemConfiguration.wrap(value)
        )
    override val fileSystemTypeVersion: Optional[FileSystemTypeVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemTypeVersion())
        .map(value => zio.aws.fsx.model.primitives.FileSystemTypeVersion(value))
    override val openZFSConfiguration
        : Optional[zio.aws.fsx.model.OpenZFSFileSystemConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openZFSConfiguration())
        .map(value =>
          zio.aws.fsx.model.OpenZFSFileSystemConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileSystem
  ): zio.aws.fsx.model.FileSystem.ReadOnly = new Wrapper(impl)
}
