package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FileSystemEndpoints(
    intercluster: Optional[zio.aws.fsx.model.FileSystemEndpoint] =
      Optional.Absent,
    management: Optional[zio.aws.fsx.model.FileSystemEndpoint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.FileSystemEndpoints = {
    import FileSystemEndpoints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.FileSystemEndpoints
      .builder()
      .optionallyWith(intercluster.map(value => value.buildAwsValue()))(
        _.intercluster
      )
      .optionallyWith(management.map(value => value.buildAwsValue()))(
        _.management
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.FileSystemEndpoints.ReadOnly =
    zio.aws.fsx.model.FileSystemEndpoints.wrap(buildAwsValue())
}
object FileSystemEndpoints {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.FileSystemEndpoints
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.FileSystemEndpoints =
      zio.aws.fsx.model.FileSystemEndpoints(
        intercluster.map(value => value.asEditable),
        management.map(value => value.asEditable)
      )
    def intercluster: Optional[zio.aws.fsx.model.FileSystemEndpoint.ReadOnly]
    def management: Optional[zio.aws.fsx.model.FileSystemEndpoint.ReadOnly]
    def getIntercluster
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("intercluster", intercluster)
    def getManagement
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystemEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("management", management)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.FileSystemEndpoints
  ) extends zio.aws.fsx.model.FileSystemEndpoints.ReadOnly {
    override val intercluster
        : Optional[zio.aws.fsx.model.FileSystemEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intercluster())
        .map(value => zio.aws.fsx.model.FileSystemEndpoint.wrap(value))
    override val management
        : Optional[zio.aws.fsx.model.FileSystemEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.management())
        .map(value => zio.aws.fsx.model.FileSystemEndpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.FileSystemEndpoints
  ): zio.aws.fsx.model.FileSystemEndpoints.ReadOnly = new Wrapper(impl)
}
