package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.ErrorMessage
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LifecycleTransitionReason(
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.LifecycleTransitionReason = {
    import LifecycleTransitionReason.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.LifecycleTransitionReason
      .builder()
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly =
    zio.aws.fsx.model.LifecycleTransitionReason.wrap(buildAwsValue())
}
object LifecycleTransitionReason {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.LifecycleTransitionReason
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.LifecycleTransitionReason =
      zio.aws.fsx.model.LifecycleTransitionReason(message.map(value => value))
    def message: Optional[ErrorMessage]
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.LifecycleTransitionReason
  ) extends zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly {
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.fsx.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.LifecycleTransitionReason
  ): zio.aws.fsx.model.LifecycleTransitionReason.ReadOnly = new Wrapper(impl)
}
