package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait OntapVolumeType {
  def unwrap: software.amazon.awssdk.services.fsx.model.OntapVolumeType
}
object OntapVolumeType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.OntapVolumeType
  ): zio.aws.fsx.model.OntapVolumeType = value match {
    case software.amazon.awssdk.services.fsx.model.OntapVolumeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.OntapVolumeType.RW =>
      val r = RW
      r
    case software.amazon.awssdk.services.fsx.model.OntapVolumeType.DP =>
      val r = DP
      r
    case software.amazon.awssdk.services.fsx.model.OntapVolumeType.LS =>
      val r = LS
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.OntapVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OntapVolumeType =
      software.amazon.awssdk.services.fsx.model.OntapVolumeType.UNKNOWN_TO_SDK_VERSION
  }
  case object RW extends zio.aws.fsx.model.OntapVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OntapVolumeType =
      software.amazon.awssdk.services.fsx.model.OntapVolumeType.RW
  }
  case object DP extends zio.aws.fsx.model.OntapVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OntapVolumeType =
      software.amazon.awssdk.services.fsx.model.OntapVolumeType.DP
  }
  case object LS extends zio.aws.fsx.model.OntapVolumeType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OntapVolumeType =
      software.amazon.awssdk.services.fsx.model.OntapVolumeType.LS
  }
}
