package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait OpenZFSCopyStrategy {
  def unwrap: software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy
}
object OpenZFSCopyStrategy {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy
  ): zio.aws.fsx.model.OpenZFSCopyStrategy = value match {
    case software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy.CLONE =>
      val r = CLONE
      r
    case software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy.FULL_COPY =>
      val r = FULL_COPY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.OpenZFSCopyStrategy {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy =
      software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy.UNKNOWN_TO_SDK_VERSION
  }
  case object CLONE extends zio.aws.fsx.model.OpenZFSCopyStrategy {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy =
      software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy.CLONE
  }
  case object FULL_COPY extends zio.aws.fsx.model.OpenZFSCopyStrategy {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy =
      software.amazon.awssdk.services.fsx.model.OpenZFSCopyStrategy.FULL_COPY
  }
}
