package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait OpenZFSDeploymentType {
  def unwrap: software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType
}
object OpenZFSDeploymentType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType
  ): zio.aws.fsx.model.OpenZFSDeploymentType = value match {
    case software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType.SINGLE_AZ_1 =>
      val r = SINGLE_AZ_1
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.OpenZFSDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType =
      software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType.UNKNOWN_TO_SDK_VERSION
  }
  case object SINGLE_AZ_1 extends zio.aws.fsx.model.OpenZFSDeploymentType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType =
      software.amazon.awssdk.services.fsx.model.OpenZFSDeploymentType.SINGLE_AZ_1
  }
}
