package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.ResourceARN
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class OpenZFSOriginSnapshotConfiguration(
    snapshotARN: Optional[ResourceARN] = Optional.Absent,
    copyStrategy: Optional[zio.aws.fsx.model.OpenZFSCopyStrategy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.OpenZFSOriginSnapshotConfiguration = {
    import OpenZFSOriginSnapshotConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.OpenZFSOriginSnapshotConfiguration
      .builder()
      .optionallyWith(
        snapshotARN.map(value => ResourceARN.unwrap(value): java.lang.String)
      )(_.snapshotARN)
      .optionallyWith(copyStrategy.map(value => value.unwrap))(_.copyStrategy)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration.ReadOnly =
    zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration.wrap(buildAwsValue())
}
object OpenZFSOriginSnapshotConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.OpenZFSOriginSnapshotConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration =
      zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration(
        snapshotARN.map(value => value),
        copyStrategy.map(value => value)
      )
    def snapshotARN: Optional[ResourceARN]
    def copyStrategy: Optional[zio.aws.fsx.model.OpenZFSCopyStrategy]
    def getSnapshotARN: ZIO[Any, AwsError, ResourceARN] =
      AwsError.unwrapOptionField("snapshotARN", snapshotARN)
    def getCopyStrategy
        : ZIO[Any, AwsError, zio.aws.fsx.model.OpenZFSCopyStrategy] =
      AwsError.unwrapOptionField("copyStrategy", copyStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSOriginSnapshotConfiguration
  ) extends zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration.ReadOnly {
    override val snapshotARN: Optional[ResourceARN] = zio.aws.core.internal
      .optionalFromNullable(impl.snapshotARN())
      .map(value => zio.aws.fsx.model.primitives.ResourceARN(value))
    override val copyStrategy: Optional[zio.aws.fsx.model.OpenZFSCopyStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.copyStrategy())
        .map(value => zio.aws.fsx.model.OpenZFSCopyStrategy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.OpenZFSOriginSnapshotConfiguration
  ): zio.aws.fsx.model.OpenZFSOriginSnapshotConfiguration.ReadOnly =
    new Wrapper(impl)
}
