package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait OpenZFSQuotaType {
  def unwrap: software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType
}
object OpenZFSQuotaType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType
  ): zio.aws.fsx.model.OpenZFSQuotaType = value match {
    case software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType.GROUP =>
      val r = GROUP
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.OpenZFSQuotaType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType =
      software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.fsx.model.OpenZFSQuotaType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType =
      software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType.USER
  }
  case object GROUP extends zio.aws.fsx.model.OpenZFSQuotaType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType =
      software.amazon.awssdk.services.fsx.model.OpenZFSQuotaType.GROUP
  }
}
