package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3DataRepositoryConfiguration(
    autoImportPolicy: Optional[zio.aws.fsx.model.AutoImportPolicy] =
      Optional.Absent,
    autoExportPolicy: Optional[zio.aws.fsx.model.AutoExportPolicy] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.S3DataRepositoryConfiguration = {
    import S3DataRepositoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.S3DataRepositoryConfiguration
      .builder()
      .optionallyWith(autoImportPolicy.map(value => value.buildAwsValue()))(
        _.autoImportPolicy
      )
      .optionallyWith(autoExportPolicy.map(value => value.buildAwsValue()))(
        _.autoExportPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly =
    zio.aws.fsx.model.S3DataRepositoryConfiguration.wrap(buildAwsValue())
}
object S3DataRepositoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.S3DataRepositoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.S3DataRepositoryConfiguration =
      zio.aws.fsx.model.S3DataRepositoryConfiguration(
        autoImportPolicy.map(value => value.asEditable),
        autoExportPolicy.map(value => value.asEditable)
      )
    def autoImportPolicy: Optional[zio.aws.fsx.model.AutoImportPolicy.ReadOnly]
    def autoExportPolicy: Optional[zio.aws.fsx.model.AutoExportPolicy.ReadOnly]
    def getAutoImportPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.AutoImportPolicy.ReadOnly] =
      AwsError.unwrapOptionField("autoImportPolicy", autoImportPolicy)
    def getAutoExportPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.AutoExportPolicy.ReadOnly] =
      AwsError.unwrapOptionField("autoExportPolicy", autoExportPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.S3DataRepositoryConfiguration
  ) extends zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly {
    override val autoImportPolicy
        : Optional[zio.aws.fsx.model.AutoImportPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoImportPolicy())
        .map(value => zio.aws.fsx.model.AutoImportPolicy.wrap(value))
    override val autoExportPolicy
        : Optional[zio.aws.fsx.model.AutoExportPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoExportPolicy())
        .map(value => zio.aws.fsx.model.AutoExportPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.S3DataRepositoryConfiguration
  ): zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
