package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait SecurityStyle {
  def unwrap: software.amazon.awssdk.services.fsx.model.SecurityStyle
}
object SecurityStyle {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.SecurityStyle
  ): zio.aws.fsx.model.SecurityStyle = value match {
    case software.amazon.awssdk.services.fsx.model.SecurityStyle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.SecurityStyle.UNIX =>
      val r = UNIX
      r
    case software.amazon.awssdk.services.fsx.model.SecurityStyle.NTFS =>
      val r = NTFS
      r
    case software.amazon.awssdk.services.fsx.model.SecurityStyle.MIXED =>
      val r = MIXED
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.SecurityStyle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SecurityStyle =
      software.amazon.awssdk.services.fsx.model.SecurityStyle.UNKNOWN_TO_SDK_VERSION
  }
  case object UNIX extends zio.aws.fsx.model.SecurityStyle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SecurityStyle =
      software.amazon.awssdk.services.fsx.model.SecurityStyle.UNIX
  }
  case object NTFS extends zio.aws.fsx.model.SecurityStyle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SecurityStyle =
      software.amazon.awssdk.services.fsx.model.SecurityStyle.NTFS
  }
  case object MIXED extends zio.aws.fsx.model.SecurityStyle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SecurityStyle =
      software.amazon.awssdk.services.fsx.model.SecurityStyle.MIXED
  }
}
