package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  IpAddress,
  FileSystemAdministratorsGroupName,
  ActiveDirectoryFullyQualifiedName,
  OrganizationalUnitDistinguishedName,
  DirectoryUserName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SelfManagedActiveDirectoryAttributes(
    domainName: Optional[ActiveDirectoryFullyQualifiedName] = Optional.Absent,
    organizationalUnitDistinguishedName: Optional[
      OrganizationalUnitDistinguishedName
    ] = Optional.Absent,
    fileSystemAdministratorsGroup: Optional[FileSystemAdministratorsGroupName] =
      Optional.Absent,
    userName: Optional[DirectoryUserName] = Optional.Absent,
    dnsIps: Optional[Iterable[IpAddress]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes = {
    import SelfManagedActiveDirectoryAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes
      .builder()
      .optionallyWith(
        domainName.map(value =>
          ActiveDirectoryFullyQualifiedName.unwrap(value): java.lang.String
        )
      )(_.domainName)
      .optionallyWith(
        organizationalUnitDistinguishedName.map(value =>
          OrganizationalUnitDistinguishedName.unwrap(value): java.lang.String
        )
      )(_.organizationalUnitDistinguishedName)
      .optionallyWith(
        fileSystemAdministratorsGroup.map(value =>
          FileSystemAdministratorsGroupName.unwrap(value): java.lang.String
        )
      )(_.fileSystemAdministratorsGroup)
      .optionallyWith(
        userName.map(value => DirectoryUserName.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        dnsIps.map(value =>
          value.map { item =>
            IpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIps)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly =
    zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.wrap(buildAwsValue())
}
object SelfManagedActiveDirectoryAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes =
      zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes(
        domainName.map(value => value),
        organizationalUnitDistinguishedName.map(value => value),
        fileSystemAdministratorsGroup.map(value => value),
        userName.map(value => value),
        dnsIps.map(value => value)
      )
    def domainName: Optional[ActiveDirectoryFullyQualifiedName]
    def organizationalUnitDistinguishedName
        : Optional[OrganizationalUnitDistinguishedName]
    def fileSystemAdministratorsGroup
        : Optional[FileSystemAdministratorsGroupName]
    def userName: Optional[DirectoryUserName]
    def dnsIps: Optional[List[IpAddress]]
    def getDomainName: ZIO[Any, AwsError, ActiveDirectoryFullyQualifiedName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getOrganizationalUnitDistinguishedName
        : ZIO[Any, AwsError, OrganizationalUnitDistinguishedName] =
      AwsError.unwrapOptionField(
        "organizationalUnitDistinguishedName",
        organizationalUnitDistinguishedName
      )
    def getFileSystemAdministratorsGroup
        : ZIO[Any, AwsError, FileSystemAdministratorsGroupName] =
      AwsError.unwrapOptionField(
        "fileSystemAdministratorsGroup",
        fileSystemAdministratorsGroup
      )
    def getUserName: ZIO[Any, AwsError, DirectoryUserName] =
      AwsError.unwrapOptionField("userName", userName)
    def getDnsIps: ZIO[Any, AwsError, List[IpAddress]] =
      AwsError.unwrapOptionField("dnsIps", dnsIps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes
  ) extends zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly {
    override val domainName: Optional[ActiveDirectoryFullyQualifiedName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainName())
        .map(value =>
          zio.aws.fsx.model.primitives.ActiveDirectoryFullyQualifiedName(value)
        )
    override val organizationalUnitDistinguishedName
        : Optional[OrganizationalUnitDistinguishedName] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationalUnitDistinguishedName())
      .map(value =>
        zio.aws.fsx.model.primitives.OrganizationalUnitDistinguishedName(value)
      )
    override val fileSystemAdministratorsGroup
        : Optional[FileSystemAdministratorsGroupName] = zio.aws.core.internal
      .optionalFromNullable(impl.fileSystemAdministratorsGroup())
      .map(value =>
        zio.aws.fsx.model.primitives.FileSystemAdministratorsGroupName(value)
      )
    override val userName: Optional[DirectoryUserName] = zio.aws.core.internal
      .optionalFromNullable(impl.userName())
      .map(value => zio.aws.fsx.model.primitives.DirectoryUserName(value))
    override val dnsIps: Optional[List[IpAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsIps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.IpAddress(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.SelfManagedActiveDirectoryAttributes
  ): zio.aws.fsx.model.SelfManagedActiveDirectoryAttributes.ReadOnly =
    new Wrapper(impl)
}
