package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.SnapshotFilterValue
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SnapshotFilter(
    name: Optional[zio.aws.fsx.model.SnapshotFilterName] = Optional.Absent,
    values: Optional[Iterable[SnapshotFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.SnapshotFilter = {
    import SnapshotFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.SnapshotFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            SnapshotFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.SnapshotFilter.ReadOnly =
    zio.aws.fsx.model.SnapshotFilter.wrap(buildAwsValue())
}
object SnapshotFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.SnapshotFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.SnapshotFilter = zio.aws.fsx.model
      .SnapshotFilter(name.map(value => value), values.map(value => value))
    def name: Optional[zio.aws.fsx.model.SnapshotFilterName]
    def values: Optional[List[SnapshotFilterValue]]
    def getName: ZIO[Any, AwsError, zio.aws.fsx.model.SnapshotFilterName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[SnapshotFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.SnapshotFilter
  ) extends zio.aws.fsx.model.SnapshotFilter.ReadOnly {
    override val name: Optional[zio.aws.fsx.model.SnapshotFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.fsx.model.SnapshotFilterName.wrap(value))
    override val values: Optional[List[SnapshotFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.SnapshotFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.SnapshotFilter
  ): zio.aws.fsx.model.SnapshotFilter.ReadOnly = new Wrapper(impl)
}
