package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait SnapshotFilterName {
  def unwrap: software.amazon.awssdk.services.fsx.model.SnapshotFilterName
}
object SnapshotFilterName {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.SnapshotFilterName
  ): zio.aws.fsx.model.SnapshotFilterName = value match {
    case software.amazon.awssdk.services.fsx.model.SnapshotFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.SnapshotFilterName.FILE_SYSTEM_ID =>
      val r = `file-system-id`
      r
    case software.amazon.awssdk.services.fsx.model.SnapshotFilterName.VOLUME_ID =>
      val r = `volume-id`
      r
  }
  case object unknownToSdkVersion extends zio.aws.fsx.model.SnapshotFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SnapshotFilterName =
      software.amazon.awssdk.services.fsx.model.SnapshotFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object `file-system-id` extends zio.aws.fsx.model.SnapshotFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SnapshotFilterName =
      software.amazon.awssdk.services.fsx.model.SnapshotFilterName.FILE_SYSTEM_ID
  }
  case object `volume-id` extends zio.aws.fsx.model.SnapshotFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.SnapshotFilterName =
      software.amazon.awssdk.services.fsx.model.SnapshotFilterName.VOLUME_ID
  }
}
