package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.StorageVirtualMachineFilterValue
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StorageVirtualMachineFilter(
    name: Optional[zio.aws.fsx.model.StorageVirtualMachineFilterName] =
      Optional.Absent,
    values: Optional[Iterable[StorageVirtualMachineFilterValue]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilter = {
    import StorageVirtualMachineFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            StorageVirtualMachineFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.StorageVirtualMachineFilter.ReadOnly =
    zio.aws.fsx.model.StorageVirtualMachineFilter.wrap(buildAwsValue())
}
object StorageVirtualMachineFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.StorageVirtualMachineFilter =
      zio.aws.fsx.model.StorageVirtualMachineFilter(
        name.map(value => value),
        values.map(value => value)
      )
    def name: Optional[zio.aws.fsx.model.StorageVirtualMachineFilterName]
    def values: Optional[List[StorageVirtualMachineFilterValue]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.StorageVirtualMachineFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[StorageVirtualMachineFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilter
  ) extends zio.aws.fsx.model.StorageVirtualMachineFilter.ReadOnly {
    override val name
        : Optional[zio.aws.fsx.model.StorageVirtualMachineFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.fsx.model.StorageVirtualMachineFilterName.wrap(value)
        )
    override val values: Optional[List[StorageVirtualMachineFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.StorageVirtualMachineFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilter
  ): zio.aws.fsx.model.StorageVirtualMachineFilter.ReadOnly = new Wrapper(impl)
}
