package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait StorageVirtualMachineFilterName {
  def unwrap: software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilterName
}
object StorageVirtualMachineFilterName {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilterName
  ): zio.aws.fsx.model.StorageVirtualMachineFilterName = value match {
    case software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilterName.FILE_SYSTEM_ID =>
      val r = `file-system-id`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.StorageVirtualMachineFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilterName =
      software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object `file-system-id`
      extends zio.aws.fsx.model.StorageVirtualMachineFilterName {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilterName =
      software.amazon.awssdk.services.fsx.model.StorageVirtualMachineFilterName.FILE_SYSTEM_ID
  }
}
