package zio.aws.fsx.model
import scala.jdk.CollectionConverters._
sealed trait StorageVirtualMachineSubtype {
  def unwrap
      : software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype
}
object StorageVirtualMachineSubtype {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype
  ): zio.aws.fsx.model.StorageVirtualMachineSubtype = value match {
    case software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.DEFAULT =>
      val r = DEFAULT
      r
    case software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.DP_DESTINATION =>
      val r = DP_DESTINATION
      r
    case software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.SYNC_DESTINATION =>
      val r = SYNC_DESTINATION
      r
    case software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.SYNC_SOURCE =>
      val r = SYNC_SOURCE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.StorageVirtualMachineSubtype {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype =
      software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.UNKNOWN_TO_SDK_VERSION
  }
  case object DEFAULT extends zio.aws.fsx.model.StorageVirtualMachineSubtype {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype =
      software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.DEFAULT
  }
  case object DP_DESTINATION
      extends zio.aws.fsx.model.StorageVirtualMachineSubtype {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype =
      software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.DP_DESTINATION
  }
  case object SYNC_DESTINATION
      extends zio.aws.fsx.model.StorageVirtualMachineSubtype {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype =
      software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.SYNC_DESTINATION
  }
  case object SYNC_SOURCE
      extends zio.aws.fsx.model.StorageVirtualMachineSubtype {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype =
      software.amazon.awssdk.services.fsx.model.StorageVirtualMachineSubtype.SYNC_SOURCE
  }
}
