package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SvmEndpoints(
    iscsi: Optional[zio.aws.fsx.model.SvmEndpoint] = Optional.Absent,
    management: Optional[zio.aws.fsx.model.SvmEndpoint] = Optional.Absent,
    nfs: Optional[zio.aws.fsx.model.SvmEndpoint] = Optional.Absent,
    smb: Optional[zio.aws.fsx.model.SvmEndpoint] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.SvmEndpoints = {
    import SvmEndpoints.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.SvmEndpoints
      .builder()
      .optionallyWith(iscsi.map(value => value.buildAwsValue()))(_.iscsi)
      .optionallyWith(management.map(value => value.buildAwsValue()))(
        _.management
      )
      .optionallyWith(nfs.map(value => value.buildAwsValue()))(_.nfs)
      .optionallyWith(smb.map(value => value.buildAwsValue()))(_.smb)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.SvmEndpoints.ReadOnly =
    zio.aws.fsx.model.SvmEndpoints.wrap(buildAwsValue())
}
object SvmEndpoints {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.SvmEndpoints] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.SvmEndpoints =
      zio.aws.fsx.model.SvmEndpoints(
        iscsi.map(value => value.asEditable),
        management.map(value => value.asEditable),
        nfs.map(value => value.asEditable),
        smb.map(value => value.asEditable)
      )
    def iscsi: Optional[zio.aws.fsx.model.SvmEndpoint.ReadOnly]
    def management: Optional[zio.aws.fsx.model.SvmEndpoint.ReadOnly]
    def nfs: Optional[zio.aws.fsx.model.SvmEndpoint.ReadOnly]
    def smb: Optional[zio.aws.fsx.model.SvmEndpoint.ReadOnly]
    def getIscsi: ZIO[Any, AwsError, zio.aws.fsx.model.SvmEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("iscsi", iscsi)
    def getManagement
        : ZIO[Any, AwsError, zio.aws.fsx.model.SvmEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("management", management)
    def getNfs: ZIO[Any, AwsError, zio.aws.fsx.model.SvmEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("nfs", nfs)
    def getSmb: ZIO[Any, AwsError, zio.aws.fsx.model.SvmEndpoint.ReadOnly] =
      AwsError.unwrapOptionField("smb", smb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.SvmEndpoints
  ) extends zio.aws.fsx.model.SvmEndpoints.ReadOnly {
    override val iscsi: Optional[zio.aws.fsx.model.SvmEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iscsi())
        .map(value => zio.aws.fsx.model.SvmEndpoint.wrap(value))
    override val management: Optional[zio.aws.fsx.model.SvmEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.management())
        .map(value => zio.aws.fsx.model.SvmEndpoint.wrap(value))
    override val nfs: Optional[zio.aws.fsx.model.SvmEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfs())
        .map(value => zio.aws.fsx.model.SvmEndpoint.wrap(value))
    override val smb: Optional[zio.aws.fsx.model.SvmEndpoint.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smb())
        .map(value => zio.aws.fsx.model.SvmEndpoint.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.SvmEndpoints
  ): zio.aws.fsx.model.SvmEndpoints.ReadOnly = new Wrapper(impl)
}
