package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.CoolingPeriod
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TieringPolicy(
    coolingPeriod: Optional[CoolingPeriod] = Optional.Absent,
    name: Optional[zio.aws.fsx.model.TieringPolicyName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.TieringPolicy = {
    import TieringPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.TieringPolicy
      .builder()
      .optionallyWith(
        coolingPeriod.map(value => CoolingPeriod.unwrap(value): Integer)
      )(_.coolingPeriod)
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.TieringPolicy.ReadOnly =
    zio.aws.fsx.model.TieringPolicy.wrap(buildAwsValue())
}
object TieringPolicy {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.TieringPolicy] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.TieringPolicy =
      zio.aws.fsx.model.TieringPolicy(
        coolingPeriod.map(value => value),
        name.map(value => value)
      )
    def coolingPeriod: Optional[CoolingPeriod]
    def name: Optional[zio.aws.fsx.model.TieringPolicyName]
    def getCoolingPeriod: ZIO[Any, AwsError, CoolingPeriod] =
      AwsError.unwrapOptionField("coolingPeriod", coolingPeriod)
    def getName: ZIO[Any, AwsError, zio.aws.fsx.model.TieringPolicyName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.TieringPolicy
  ) extends zio.aws.fsx.model.TieringPolicy.ReadOnly {
    override val coolingPeriod: Optional[CoolingPeriod] = zio.aws.core.internal
      .optionalFromNullable(impl.coolingPeriod())
      .map(value => zio.aws.fsx.model.primitives.CoolingPeriod(value))
    override val name: Optional[zio.aws.fsx.model.TieringPolicyName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.fsx.model.TieringPolicyName.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.TieringPolicy
  ): zio.aws.fsx.model.TieringPolicy.ReadOnly = new Wrapper(impl)
}
