package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  Megabytes,
  ClientRequestToken,
  DataRepositoryAssociationId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateDataRepositoryAssociationRequest(
    associationId: DataRepositoryAssociationId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    importedFileChunkSize: Optional[Megabytes] = Optional.Absent,
    s3: Optional[zio.aws.fsx.model.S3DataRepositoryConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest = {
    import UpdateDataRepositoryAssociationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest
      .builder()
      .associationId(
        DataRepositoryAssociationId.unwrap(associationId): java.lang.String
      )
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        importedFileChunkSize.map(value => Megabytes.unwrap(value): Integer)
      )(_.importedFileChunkSize)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest.ReadOnly =
    zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest
      .wrap(buildAwsValue())
}
object UpdateDataRepositoryAssociationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest =
      zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest(
        associationId,
        clientRequestToken.map(value => value),
        importedFileChunkSize.map(value => value),
        s3.map(value => value.asEditable)
      )
    def associationId: DataRepositoryAssociationId
    def clientRequestToken: Optional[ClientRequestToken]
    def importedFileChunkSize: Optional[Megabytes]
    def s3: Optional[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly]
    def getAssociationId: ZIO[Any, Nothing, DataRepositoryAssociationId] =
      ZIO.succeed(associationId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getImportedFileChunkSize: ZIO[Any, AwsError, Megabytes] =
      AwsError.unwrapOptionField("importedFileChunkSize", importedFileChunkSize)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest
  ) extends zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest.ReadOnly {
    override val associationId: DataRepositoryAssociationId =
      zio.aws.fsx.model.primitives
        .DataRepositoryAssociationId(impl.associationId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val importedFileChunkSize: Optional[Megabytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedFileChunkSize())
        .map(value => zio.aws.fsx.model.primitives.Megabytes(value))
    override val s3
        : Optional[zio.aws.fsx.model.S3DataRepositoryConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value =>
          zio.aws.fsx.model.S3DataRepositoryConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateDataRepositoryAssociationRequest
  ): zio.aws.fsx.model.UpdateDataRepositoryAssociationRequest.ReadOnly =
    new Wrapper(impl)
}
