package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  WeeklyTime,
  Flag
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class UpdateFileSystemOpenZFSConfiguration(
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    copyTagsToBackups: Optional[Flag] = Optional.Absent,
    copyTagsToVolumes: Optional[Flag] = Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    throughputCapacity: Optional[MegabytesPerSecond] = Optional.Absent,
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    diskIopsConfiguration: Optional[zio.aws.fsx.model.DiskIopsConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration = {
    import UpdateFileSystemOpenZFSConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration
      .builder()
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(
        copyTagsToVolumes.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToVolumes)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        throughputCapacity.map(value =>
          MegabytesPerSecond.unwrap(value): Integer
        )
      )(_.throughputCapacity)
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        diskIopsConfiguration.map(value => value.buildAwsValue())
      )(_.diskIopsConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.ReadOnly =
    zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.wrap(buildAwsValue())
}
object UpdateFileSystemOpenZFSConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration =
      zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration(
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        copyTagsToVolumes.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        throughputCapacity.map(value => value),
        weeklyMaintenanceStartTime.map(value => value),
        diskIopsConfiguration.map(value => value.asEditable)
      )
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Optional[Flag]
    def copyTagsToVolumes: Optional[Flag]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def throughputCapacity: Optional[MegabytesPerSecond]
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly]
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getCopyTagsToVolumes: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToVolumes", copyTagsToVolumes)
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getThroughputCapacity: ZIO[Any, AwsError, MegabytesPerSecond] =
      AwsError.unwrapOptionField("throughputCapacity", throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDiskIopsConfiguration
        : ZIO[Any, AwsError, zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("diskIopsConfiguration", diskIopsConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration
  ) extends zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.ReadOnly {
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val copyTagsToVolumes: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToVolumes())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val throughputCapacity: Optional[MegabytesPerSecond] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputCapacity())
        .map(value => zio.aws.fsx.model.primitives.MegabytesPerSecond(value))
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val diskIopsConfiguration
        : Optional[zio.aws.fsx.model.DiskIopsConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.diskIopsConfiguration())
        .map(value => zio.aws.fsx.model.DiskIopsConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.UpdateFileSystemOpenZFSConfiguration
  ): zio.aws.fsx.model.UpdateFileSystemOpenZFSConfiguration.ReadOnly =
    new Wrapper(impl)
}
