package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.VolumeFilterValue
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VolumeFilter(
    name: Optional[zio.aws.fsx.model.VolumeFilterName] = Optional.Absent,
    values: Optional[Iterable[VolumeFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.VolumeFilter = {
    import VolumeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.VolumeFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            VolumeFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.VolumeFilter.ReadOnly =
    zio.aws.fsx.model.VolumeFilter.wrap(buildAwsValue())
}
object VolumeFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.VolumeFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.VolumeFilter = zio.aws.fsx.model
      .VolumeFilter(name.map(value => value), values.map(value => value))
    def name: Optional[zio.aws.fsx.model.VolumeFilterName]
    def values: Optional[List[VolumeFilterValue]]
    def getName: ZIO[Any, AwsError, zio.aws.fsx.model.VolumeFilterName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[VolumeFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.VolumeFilter
  ) extends zio.aws.fsx.model.VolumeFilter.ReadOnly {
    override val name: Optional[zio.aws.fsx.model.VolumeFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value => zio.aws.fsx.model.VolumeFilterName.wrap(value))
    override val values: Optional[List[VolumeFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.VolumeFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.VolumeFilter
  ): zio.aws.fsx.model.VolumeFilter.ReadOnly = new Wrapper(impl)
}
