package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.GeneralARN
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class WindowsAuditLogConfiguration(
    fileAccessAuditLogLevel: zio.aws.fsx.model.WindowsAccessAuditLogLevel,
    fileShareAccessAuditLogLevel: zio.aws.fsx.model.WindowsAccessAuditLogLevel,
    auditLogDestination: Optional[GeneralARN] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.WindowsAuditLogConfiguration = {
    import WindowsAuditLogConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.WindowsAuditLogConfiguration
      .builder()
      .fileAccessAuditLogLevel(fileAccessAuditLogLevel.unwrap)
      .fileShareAccessAuditLogLevel(fileShareAccessAuditLogLevel.unwrap)
      .optionallyWith(
        auditLogDestination.map(value =>
          GeneralARN.unwrap(value): java.lang.String
        )
      )(_.auditLogDestination)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.WindowsAuditLogConfiguration.ReadOnly =
    zio.aws.fsx.model.WindowsAuditLogConfiguration.wrap(buildAwsValue())
}
object WindowsAuditLogConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.WindowsAuditLogConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.WindowsAuditLogConfiguration =
      zio.aws.fsx.model.WindowsAuditLogConfiguration(
        fileAccessAuditLogLevel,
        fileShareAccessAuditLogLevel,
        auditLogDestination.map(value => value)
      )
    def fileAccessAuditLogLevel: zio.aws.fsx.model.WindowsAccessAuditLogLevel
    def fileShareAccessAuditLogLevel
        : zio.aws.fsx.model.WindowsAccessAuditLogLevel
    def auditLogDestination: Optional[GeneralARN]
    def getFileAccessAuditLogLevel
        : ZIO[Any, Nothing, zio.aws.fsx.model.WindowsAccessAuditLogLevel] =
      ZIO.succeed(fileAccessAuditLogLevel)
    def getFileShareAccessAuditLogLevel
        : ZIO[Any, Nothing, zio.aws.fsx.model.WindowsAccessAuditLogLevel] =
      ZIO.succeed(fileShareAccessAuditLogLevel)
    def getAuditLogDestination: ZIO[Any, AwsError, GeneralARN] =
      AwsError.unwrapOptionField("auditLogDestination", auditLogDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.WindowsAuditLogConfiguration
  ) extends zio.aws.fsx.model.WindowsAuditLogConfiguration.ReadOnly {
    override val fileAccessAuditLogLevel
        : zio.aws.fsx.model.WindowsAccessAuditLogLevel =
      zio.aws.fsx.model.WindowsAccessAuditLogLevel
        .wrap(impl.fileAccessAuditLogLevel())
    override val fileShareAccessAuditLogLevel
        : zio.aws.fsx.model.WindowsAccessAuditLogLevel =
      zio.aws.fsx.model.WindowsAccessAuditLogLevel
        .wrap(impl.fileShareAccessAuditLogLevel())
    override val auditLogDestination: Optional[GeneralARN] =
      zio.aws.core.internal
        .optionalFromNullable(impl.auditLogDestination())
        .map(value => zio.aws.fsx.model.primitives.GeneralARN(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.WindowsAuditLogConfiguration
  ): zio.aws.fsx.model.WindowsAuditLogConfiguration.ReadOnly = new Wrapper(impl)
}
