package zio.aws.fsx
import zio.aws.fsx.model.DescribeSnapshotsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.fsx.FSxAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.fsx.model.{
  DisassociateFileSystemAliasesRequest,
  UpdateStorageVirtualMachineRequest,
  DeleteFileSystemRequest,
  CreateBackupRequest,
  AssociateFileSystemAliasesRequest,
  DescribeSnapshotsRequest,
  DeleteVolumeRequest,
  DeleteSnapshotRequest,
  CancelDataRepositoryTaskRequest,
  DescribeFileSystemsRequest,
  DescribeDataRepositoryAssociationsRequest,
  UpdateSnapshotRequest,
  ListTagsForResourceRequest,
  UpdateVolumeRequest,
  DeleteStorageVirtualMachineRequest,
  RestoreVolumeFromSnapshotRequest,
  DescribeVolumesRequest,
  CopyBackupRequest,
  CreateDataRepositoryTaskRequest,
  CreateDataRepositoryAssociationRequest,
  DescribeFileSystemAliasesRequest,
  CreateFileSystemFromBackupRequest,
  CreateVolumeRequest,
  DeleteBackupRequest,
  DescribeDataRepositoryTasksRequest,
  UntagResourceRequest,
  UpdateFileSystemRequest,
  CreateFileSystemRequest,
  CreateSnapshotRequest,
  ReleaseFileSystemNfsV3LocksRequest,
  DescribeBackupsRequest,
  CreateStorageVirtualMachineRequest,
  DescribeStorageVirtualMachinesRequest,
  CreateVolumeFromBackupRequest,
  UpdateDataRepositoryAssociationRequest,
  DeleteDataRepositoryAssociationRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object FSxMock extends Mock[FSx] {
  object DisassociateFileSystemAliases
      extends Effect[
        DisassociateFileSystemAliasesRequest,
        AwsError,
        zio.aws.fsx.model.DisassociateFileSystemAliasesResponse.ReadOnly
      ]
  object DeleteDataRepositoryAssociation
      extends Effect[
        DeleteDataRepositoryAssociationRequest,
        AwsError,
        zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse.ReadOnly
      ]
  object CreateFileSystemFromBackup
      extends Effect[
        CreateFileSystemFromBackupRequest,
        AwsError,
        zio.aws.fsx.model.CreateFileSystemFromBackupResponse.ReadOnly
      ]
  object AssociateFileSystemAliases
      extends Effect[
        AssociateFileSystemAliasesRequest,
        AwsError,
        zio.aws.fsx.model.AssociateFileSystemAliasesResponse.ReadOnly
      ]
  object CreateDataRepositoryAssociation
      extends Effect[
        CreateDataRepositoryAssociationRequest,
        AwsError,
        zio.aws.fsx.model.CreateDataRepositoryAssociationResponse.ReadOnly
      ]
  object UpdateFileSystem
      extends Effect[
        UpdateFileSystemRequest,
        AwsError,
        zio.aws.fsx.model.UpdateFileSystemResponse.ReadOnly
      ]
  object DescribeStorageVirtualMachines
      extends Stream[
        DescribeStorageVirtualMachinesRequest,
        AwsError,
        zio.aws.fsx.model.StorageVirtualMachine.ReadOnly
      ]
  object DescribeStorageVirtualMachinesPaginated
      extends Effect[
        DescribeStorageVirtualMachinesRequest,
        AwsError,
        zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse.ReadOnly
      ]
  object CreateBackup
      extends Effect[
        CreateBackupRequest,
        AwsError,
        zio.aws.fsx.model.CreateBackupResponse.ReadOnly
      ]
  object RestoreVolumeFromSnapshot
      extends Effect[
        RestoreVolumeFromSnapshotRequest,
        AwsError,
        zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly
      ]
  object DescribeBackups
      extends Stream[
        DescribeBackupsRequest,
        AwsError,
        zio.aws.fsx.model.Backup.ReadOnly
      ]
  object DescribeBackupsPaginated
      extends Effect[
        DescribeBackupsRequest,
        AwsError,
        zio.aws.fsx.model.DescribeBackupsResponse.ReadOnly
      ]
  object DescribeFileSystemAliases
      extends Stream[
        DescribeFileSystemAliasesRequest,
        AwsError,
        zio.aws.fsx.model.Alias.ReadOnly
      ]
  object DescribeFileSystemAliasesPaginated
      extends Effect[
        DescribeFileSystemAliasesRequest,
        AwsError,
        zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly
      ]
  object UpdateDataRepositoryAssociation
      extends Effect[
        UpdateDataRepositoryAssociationRequest,
        AwsError,
        zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse.ReadOnly
      ]
  object ReleaseFileSystemNfsV3Locks
      extends Effect[
        ReleaseFileSystemNfsV3LocksRequest,
        AwsError,
        zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.ReadOnly
      ]
  object CreateStorageVirtualMachine
      extends Effect[
        CreateStorageVirtualMachineRequest,
        AwsError,
        zio.aws.fsx.model.CreateStorageVirtualMachineResponse.ReadOnly
      ]
  object DescribeVolumes
      extends Stream[
        DescribeVolumesRequest,
        AwsError,
        zio.aws.fsx.model.Volume.ReadOnly
      ]
  object DescribeVolumesPaginated
      extends Effect[
        DescribeVolumesRequest,
        AwsError,
        zio.aws.fsx.model.DescribeVolumesResponse.ReadOnly
      ]
  object CreateVolume
      extends Effect[
        CreateVolumeRequest,
        AwsError,
        zio.aws.fsx.model.CreateVolumeResponse.ReadOnly
      ]
  object DeleteSnapshot
      extends Effect[
        DeleteSnapshotRequest,
        AwsError,
        zio.aws.fsx.model.DeleteSnapshotResponse.ReadOnly
      ]
  object CopyBackup
      extends Effect[
        CopyBackupRequest,
        AwsError,
        zio.aws.fsx.model.CopyBackupResponse.ReadOnly
      ]
  object DeleteStorageVirtualMachine
      extends Effect[
        DeleteStorageVirtualMachineRequest,
        AwsError,
        zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.ReadOnly
      ]
  object UpdateVolume
      extends Effect[
        UpdateVolumeRequest,
        AwsError,
        zio.aws.fsx.model.UpdateVolumeResponse.ReadOnly
      ]
  object DescribeDataRepositoryAssociations
      extends Stream[
        DescribeDataRepositoryAssociationsRequest,
        AwsError,
        zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly
      ]
  object DescribeDataRepositoryAssociationsPaginated
      extends Effect[
        DescribeDataRepositoryAssociationsRequest,
        AwsError,
        zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly
      ]
  object CreateFileSystem
      extends Effect[
        CreateFileSystemRequest,
        AwsError,
        zio.aws.fsx.model.CreateFileSystemResponse.ReadOnly
      ]
  object DescribeDataRepositoryTasks
      extends Stream[
        DescribeDataRepositoryTasksRequest,
        AwsError,
        zio.aws.fsx.model.DataRepositoryTask.ReadOnly
      ]
  object DescribeDataRepositoryTasksPaginated
      extends Effect[
        DescribeDataRepositoryTasksRequest,
        AwsError,
        zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.ReadOnly
      ]
  object UpdateSnapshot
      extends Effect[
        UpdateSnapshotRequest,
        AwsError,
        zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.fsx.model.UntagResourceResponse.ReadOnly
      ]
  object DescribeFileSystems
      extends Stream[
        DescribeFileSystemsRequest,
        AwsError,
        zio.aws.fsx.model.FileSystem.ReadOnly
      ]
  object DescribeFileSystemsPaginated
      extends Effect[
        DescribeFileSystemsRequest,
        AwsError,
        zio.aws.fsx.model.DescribeFileSystemsResponse.ReadOnly
      ]
  object CreateDataRepositoryTask
      extends Effect[
        CreateDataRepositoryTaskRequest,
        AwsError,
        zio.aws.fsx.model.CreateDataRepositoryTaskResponse.ReadOnly
      ]
  object DeleteFileSystem
      extends Effect[
        DeleteFileSystemRequest,
        AwsError,
        zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly
      ]
  object CreateVolumeFromBackup
      extends Effect[
        CreateVolumeFromBackupRequest,
        AwsError,
        zio.aws.fsx.model.CreateVolumeFromBackupResponse.ReadOnly
      ]
  object CancelDataRepositoryTask
      extends Effect[
        CancelDataRepositoryTaskRequest,
        AwsError,
        zio.aws.fsx.model.CancelDataRepositoryTaskResponse.ReadOnly
      ]
  object DescribeSnapshots
      extends Stream[
        DescribeSnapshotsRequest,
        AwsError,
        zio.aws.fsx.model.Snapshot.ReadOnly
      ]
  object DescribeSnapshotsPaginated
      extends Effect[DescribeSnapshotsRequest, AwsError, ReadOnly]
  object DeleteBackup
      extends Effect[
        DeleteBackupRequest,
        AwsError,
        zio.aws.fsx.model.DeleteBackupResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.fsx.model.Tag.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.fsx.model.ListTagsForResourceResponse.ReadOnly
      ]
  object DeleteVolume
      extends Effect[
        DeleteVolumeRequest,
        AwsError,
        zio.aws.fsx.model.DeleteVolumeResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.fsx.model.TagResourceResponse.ReadOnly
      ]
  object UpdateStorageVirtualMachine
      extends Effect[
        UpdateStorageVirtualMachineRequest,
        AwsError,
        zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly
      ]
  object CreateSnapshot
      extends Effect[
        CreateSnapshotRequest,
        AwsError,
        zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, FSx] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, FSx] { rts =>
        zio.ZIO.succeed {
          new FSx {
            val api: FSxAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): FSx = this
            def disassociateFileSystemAliases(
                request: DisassociateFileSystemAliasesRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.DisassociateFileSystemAliasesResponse.ReadOnly
            ] = proxy(DisassociateFileSystemAliases, request)
            def deleteDataRepositoryAssociation(
                request: DeleteDataRepositoryAssociationRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.DeleteDataRepositoryAssociationResponse.ReadOnly
            ] = proxy(DeleteDataRepositoryAssociation, request)
            def createFileSystemFromBackup(
                request: CreateFileSystemFromBackupRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.CreateFileSystemFromBackupResponse.ReadOnly
            ] = proxy(CreateFileSystemFromBackup, request)
            def associateFileSystemAliases(
                request: AssociateFileSystemAliasesRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.AssociateFileSystemAliasesResponse.ReadOnly
            ] = proxy(AssociateFileSystemAliases, request)
            def createDataRepositoryAssociation(
                request: CreateDataRepositoryAssociationRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.CreateDataRepositoryAssociationResponse.ReadOnly
            ] = proxy(CreateDataRepositoryAssociation, request)
            def updateFileSystem(request: UpdateFileSystemRequest): IO[
              AwsError,
              zio.aws.fsx.model.UpdateFileSystemResponse.ReadOnly
            ] = proxy(UpdateFileSystem, request)
            def describeStorageVirtualMachines(
                request: DescribeStorageVirtualMachinesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.fsx.model.StorageVirtualMachine.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeStorageVirtualMachines, request))
            def describeStorageVirtualMachinesPaginated(
                request: DescribeStorageVirtualMachinesRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.DescribeStorageVirtualMachinesResponse.ReadOnly
            ] = proxy(DescribeStorageVirtualMachinesPaginated, request)
            def createBackup(
                request: CreateBackupRequest
            ): IO[AwsError, zio.aws.fsx.model.CreateBackupResponse.ReadOnly] =
              proxy(CreateBackup, request)
            def restoreVolumeFromSnapshot(
                request: RestoreVolumeFromSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.RestoreVolumeFromSnapshotResponse.ReadOnly
            ] = proxy(RestoreVolumeFromSnapshot, request)
            def describeBackups(
                request: DescribeBackupsRequest
            ): ZStream[Any, AwsError, zio.aws.fsx.model.Backup.ReadOnly] =
              rts.unsafeRun(proxy(DescribeBackups, request))
            def describeBackupsPaginated(request: DescribeBackupsRequest): IO[
              AwsError,
              zio.aws.fsx.model.DescribeBackupsResponse.ReadOnly
            ] = proxy(DescribeBackupsPaginated, request)
            def describeFileSystemAliases(
                request: DescribeFileSystemAliasesRequest
            ): ZStream[Any, AwsError, zio.aws.fsx.model.Alias.ReadOnly] =
              rts.unsafeRun(proxy(DescribeFileSystemAliases, request))
            def describeFileSystemAliasesPaginated(
                request: DescribeFileSystemAliasesRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.DescribeFileSystemAliasesResponse.ReadOnly
            ] = proxy(DescribeFileSystemAliasesPaginated, request)
            def updateDataRepositoryAssociation(
                request: UpdateDataRepositoryAssociationRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.UpdateDataRepositoryAssociationResponse.ReadOnly
            ] = proxy(UpdateDataRepositoryAssociation, request)
            def releaseFileSystemNfsV3Locks(
                request: ReleaseFileSystemNfsV3LocksRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.ReleaseFileSystemNfsV3LocksResponse.ReadOnly
            ] = proxy(ReleaseFileSystemNfsV3Locks, request)
            def createStorageVirtualMachine(
                request: CreateStorageVirtualMachineRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.CreateStorageVirtualMachineResponse.ReadOnly
            ] = proxy(CreateStorageVirtualMachine, request)
            def describeVolumes(
                request: DescribeVolumesRequest
            ): ZStream[Any, AwsError, zio.aws.fsx.model.Volume.ReadOnly] =
              rts.unsafeRun(proxy(DescribeVolumes, request))
            def describeVolumesPaginated(request: DescribeVolumesRequest): IO[
              AwsError,
              zio.aws.fsx.model.DescribeVolumesResponse.ReadOnly
            ] = proxy(DescribeVolumesPaginated, request)
            def createVolume(
                request: CreateVolumeRequest
            ): IO[AwsError, zio.aws.fsx.model.CreateVolumeResponse.ReadOnly] =
              proxy(CreateVolume, request)
            def deleteSnapshot(
                request: DeleteSnapshotRequest
            ): IO[AwsError, zio.aws.fsx.model.DeleteSnapshotResponse.ReadOnly] =
              proxy(DeleteSnapshot, request)
            def copyBackup(
                request: CopyBackupRequest
            ): IO[AwsError, zio.aws.fsx.model.CopyBackupResponse.ReadOnly] =
              proxy(CopyBackup, request)
            def deleteStorageVirtualMachine(
                request: DeleteStorageVirtualMachineRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.DeleteStorageVirtualMachineResponse.ReadOnly
            ] = proxy(DeleteStorageVirtualMachine, request)
            def updateVolume(
                request: UpdateVolumeRequest
            ): IO[AwsError, zio.aws.fsx.model.UpdateVolumeResponse.ReadOnly] =
              proxy(UpdateVolume, request)
            def describeDataRepositoryAssociations(
                request: DescribeDataRepositoryAssociationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.fsx.model.DataRepositoryAssociation.ReadOnly
            ] =
              rts.unsafeRun(proxy(DescribeDataRepositoryAssociations, request))
            def describeDataRepositoryAssociationsPaginated(
                request: DescribeDataRepositoryAssociationsRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.DescribeDataRepositoryAssociationsResponse.ReadOnly
            ] = proxy(DescribeDataRepositoryAssociationsPaginated, request)
            def createFileSystem(request: CreateFileSystemRequest): IO[
              AwsError,
              zio.aws.fsx.model.CreateFileSystemResponse.ReadOnly
            ] = proxy(CreateFileSystem, request)
            def describeDataRepositoryTasks(
                request: DescribeDataRepositoryTasksRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.fsx.model.DataRepositoryTask.ReadOnly
            ] = rts.unsafeRun(proxy(DescribeDataRepositoryTasks, request))
            def describeDataRepositoryTasksPaginated(
                request: DescribeDataRepositoryTasksRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.DescribeDataRepositoryTasksResponse.ReadOnly
            ] = proxy(DescribeDataRepositoryTasksPaginated, request)
            def updateSnapshot(
                request: UpdateSnapshotRequest
            ): IO[AwsError, zio.aws.fsx.model.UpdateSnapshotResponse.ReadOnly] =
              proxy(UpdateSnapshot, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.fsx.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def describeFileSystems(
                request: DescribeFileSystemsRequest
            ): ZStream[Any, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly] =
              rts.unsafeRun(proxy(DescribeFileSystems, request))
            def describeFileSystemsPaginated(
                request: DescribeFileSystemsRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.DescribeFileSystemsResponse.ReadOnly
            ] = proxy(DescribeFileSystemsPaginated, request)
            def createDataRepositoryTask(
                request: CreateDataRepositoryTaskRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.CreateDataRepositoryTaskResponse.ReadOnly
            ] = proxy(CreateDataRepositoryTask, request)
            def deleteFileSystem(request: DeleteFileSystemRequest): IO[
              AwsError,
              zio.aws.fsx.model.DeleteFileSystemResponse.ReadOnly
            ] = proxy(DeleteFileSystem, request)
            def createVolumeFromBackup(
                request: CreateVolumeFromBackupRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.CreateVolumeFromBackupResponse.ReadOnly
            ] = proxy(CreateVolumeFromBackup, request)
            def cancelDataRepositoryTask(
                request: CancelDataRepositoryTaskRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.CancelDataRepositoryTaskResponse.ReadOnly
            ] = proxy(CancelDataRepositoryTask, request)
            def describeSnapshots(
                request: DescribeSnapshotsRequest
            ): ZStream[Any, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly] =
              rts.unsafeRun(proxy(DescribeSnapshots, request))
            def describeSnapshotsPaginated(
                request: DescribeSnapshotsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(DescribeSnapshotsPaginated, request)
            def deleteBackup(
                request: DeleteBackupRequest
            ): IO[AwsError, zio.aws.fsx.model.DeleteBackupResponse.ReadOnly] =
              proxy(DeleteBackup, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, zio.aws.fsx.model.Tag.ReadOnly] =
              rts.unsafeRun(proxy(ListTagsForResource, request))
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def deleteVolume(
                request: DeleteVolumeRequest
            ): IO[AwsError, zio.aws.fsx.model.DeleteVolumeResponse.ReadOnly] =
              proxy(DeleteVolume, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.fsx.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def updateStorageVirtualMachine(
                request: UpdateStorageVirtualMachineRequest
            ): IO[
              AwsError,
              zio.aws.fsx.model.UpdateStorageVirtualMachineResponse.ReadOnly
            ] = proxy(UpdateStorageVirtualMachine, request)
            def createSnapshot(
                request: CreateSnapshotRequest
            ): IO[AwsError, zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly] =
              proxy(CreateSnapshot, request)
          }
        }
      }
    }
  }
}
