package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait AdministrativeActionType {
  def unwrap: software.amazon.awssdk.services.fsx.model.AdministrativeActionType
}
object AdministrativeActionType {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.AdministrativeActionType
  ): zio.aws.fsx.model.AdministrativeActionType = value match {
    case software.amazon.awssdk.services.fsx.model.AdministrativeActionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.AdministrativeActionType.FILE_SYSTEM_UPDATE =>
      val r = FILE_SYSTEM_UPDATE
      r
    case software.amazon.awssdk.services.fsx.model.AdministrativeActionType.STORAGE_OPTIMIZATION =>
      val r = STORAGE_OPTIMIZATION
      r
    case software.amazon.awssdk.services.fsx.model.AdministrativeActionType.FILE_SYSTEM_ALIAS_ASSOCIATION =>
      val r = FILE_SYSTEM_ALIAS_ASSOCIATION
      r
    case software.amazon.awssdk.services.fsx.model.AdministrativeActionType.FILE_SYSTEM_ALIAS_DISASSOCIATION =>
      val r = FILE_SYSTEM_ALIAS_DISASSOCIATION
      r
    case software.amazon.awssdk.services.fsx.model.AdministrativeActionType.VOLUME_UPDATE =>
      val r = VOLUME_UPDATE
      r
    case software.amazon.awssdk.services.fsx.model.AdministrativeActionType.SNAPSHOT_UPDATE =>
      val r = SNAPSHOT_UPDATE
      r
    case software.amazon.awssdk.services.fsx.model.AdministrativeActionType.RELEASE_NFS_V3_LOCKS =>
      val r = RELEASE_NFS_V3_LOCKS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.AdministrativeActionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AdministrativeActionType =
      software.amazon.awssdk.services.fsx.model.AdministrativeActionType.UNKNOWN_TO_SDK_VERSION
  }
  case object FILE_SYSTEM_UPDATE
      extends zio.aws.fsx.model.AdministrativeActionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AdministrativeActionType =
      software.amazon.awssdk.services.fsx.model.AdministrativeActionType.FILE_SYSTEM_UPDATE
  }
  case object STORAGE_OPTIMIZATION
      extends zio.aws.fsx.model.AdministrativeActionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AdministrativeActionType =
      software.amazon.awssdk.services.fsx.model.AdministrativeActionType.STORAGE_OPTIMIZATION
  }
  case object FILE_SYSTEM_ALIAS_ASSOCIATION
      extends zio.aws.fsx.model.AdministrativeActionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AdministrativeActionType =
      software.amazon.awssdk.services.fsx.model.AdministrativeActionType.FILE_SYSTEM_ALIAS_ASSOCIATION
  }
  case object FILE_SYSTEM_ALIAS_DISASSOCIATION
      extends zio.aws.fsx.model.AdministrativeActionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AdministrativeActionType =
      software.amazon.awssdk.services.fsx.model.AdministrativeActionType.FILE_SYSTEM_ALIAS_DISASSOCIATION
  }
  case object VOLUME_UPDATE extends zio.aws.fsx.model.AdministrativeActionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AdministrativeActionType =
      software.amazon.awssdk.services.fsx.model.AdministrativeActionType.VOLUME_UPDATE
  }
  case object SNAPSHOT_UPDATE
      extends zio.aws.fsx.model.AdministrativeActionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AdministrativeActionType =
      software.amazon.awssdk.services.fsx.model.AdministrativeActionType.SNAPSHOT_UPDATE
  }
  case object RELEASE_NFS_V3_LOCKS
      extends zio.aws.fsx.model.AdministrativeActionType {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.AdministrativeActionType =
      software.amazon.awssdk.services.fsx.model.AdministrativeActionType.RELEASE_NFS_V3_LOCKS
  }
}
