package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.AlternateDNSName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Alias(
    name: Optional[AlternateDNSName] = Optional.Absent,
    lifecycle: Optional[zio.aws.fsx.model.AliasLifecycle] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.fsx.model.Alias = {
    import Alias.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.Alias
      .builder()
      .optionallyWith(
        name.map(value => AlternateDNSName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.Alias.ReadOnly =
    zio.aws.fsx.model.Alias.wrap(buildAwsValue())
}
object Alias {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.fsx.model.Alias] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.Alias = zio.aws.fsx.model
      .Alias(name.map(value => value), lifecycle.map(value => value))
    def name: Optional[AlternateDNSName]
    def lifecycle: Optional[zio.aws.fsx.model.AliasLifecycle]
    def getName: ZIO[Any, AwsError, AlternateDNSName] =
      AwsError.unwrapOptionField("name", name)
    def getLifecycle: ZIO[Any, AwsError, zio.aws.fsx.model.AliasLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.Alias
  ) extends zio.aws.fsx.model.Alias.ReadOnly {
    override val name: Optional[AlternateDNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.fsx.model.primitives.AlternateDNSName(value))
    override val lifecycle: Optional[zio.aws.fsx.model.AliasLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.AliasLifecycle.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.Alias
  ): zio.aws.fsx.model.Alias.ReadOnly = new Wrapper(impl)
}
