package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{
  AlternateDNSName,
  FileSystemId,
  ClientRequestToken
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateFileSystemAliasesRequest(
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    fileSystemId: FileSystemId,
    aliases: Iterable[AlternateDNSName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest = {
    import AssociateFileSystemAliasesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .fileSystemId(FileSystemId.unwrap(fileSystemId): java.lang.String)
      .aliases(aliases.map { item =>
        AlternateDNSName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.AssociateFileSystemAliasesRequest.ReadOnly =
    zio.aws.fsx.model.AssociateFileSystemAliasesRequest.wrap(buildAwsValue())
}
object AssociateFileSystemAliasesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.AssociateFileSystemAliasesRequest =
      zio.aws.fsx.model.AssociateFileSystemAliasesRequest(
        clientRequestToken.map(value => value),
        fileSystemId,
        aliases
      )
    def clientRequestToken: Optional[ClientRequestToken]
    def fileSystemId: FileSystemId
    def aliases: List[AlternateDNSName]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getFileSystemId: ZIO[Any, Nothing, FileSystemId] =
      ZIO.succeed(fileSystemId)
    def getAliases: ZIO[Any, Nothing, List[AlternateDNSName]] =
      ZIO.succeed(aliases)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest
  ) extends zio.aws.fsx.model.AssociateFileSystemAliasesRequest.ReadOnly {
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val fileSystemId: FileSystemId =
      zio.aws.fsx.model.primitives.FileSystemId(impl.fileSystemId())
    override val aliases: List[AlternateDNSName] = impl
      .aliases()
      .asScala
      .map { item =>
        zio.aws.fsx.model.primitives.AlternateDNSName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.AssociateFileSystemAliasesRequest
  ): zio.aws.fsx.model.AssociateFileSystemAliasesRequest.ReadOnly = new Wrapper(
    impl
  )
}
