package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoExportPolicy(
    events: Optional[Iterable[zio.aws.fsx.model.EventType]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.AutoExportPolicy = {
    import AutoExportPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.AutoExportPolicy
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.eventsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.AutoExportPolicy.ReadOnly =
    zio.aws.fsx.model.AutoExportPolicy.wrap(buildAwsValue())
}
object AutoExportPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.AutoExportPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.AutoExportPolicy =
      zio.aws.fsx.model.AutoExportPolicy(events.map(value => value))
    def events: Optional[List[zio.aws.fsx.model.EventType]]
    def getEvents: ZIO[Any, AwsError, List[zio.aws.fsx.model.EventType]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.AutoExportPolicy
  ) extends zio.aws.fsx.model.AutoExportPolicy.ReadOnly {
    override val events: Optional[List[zio.aws.fsx.model.EventType]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.EventType.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.AutoExportPolicy
  ): zio.aws.fsx.model.AutoExportPolicy.ReadOnly = new Wrapper(impl)
}
