package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateDataRepositoryTaskResponse(
    dataRepositoryTask: Optional[zio.aws.fsx.model.DataRepositoryTask] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskResponse = {
    import CreateDataRepositoryTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskResponse
      .builder()
      .optionallyWith(dataRepositoryTask.map(value => value.buildAwsValue()))(
        _.dataRepositoryTask
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateDataRepositoryTaskResponse.ReadOnly =
    zio.aws.fsx.model.CreateDataRepositoryTaskResponse.wrap(buildAwsValue())
}
object CreateDataRepositoryTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateDataRepositoryTaskResponse =
      zio.aws.fsx.model.CreateDataRepositoryTaskResponse(
        dataRepositoryTask.map(value => value.asEditable)
      )
    def dataRepositoryTask
        : Optional[zio.aws.fsx.model.DataRepositoryTask.ReadOnly]
    def getDataRepositoryTask
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataRepositoryTask.ReadOnly] =
      AwsError.unwrapOptionField("dataRepositoryTask", dataRepositoryTask)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskResponse
  ) extends zio.aws.fsx.model.CreateDataRepositoryTaskResponse.ReadOnly {
    override val dataRepositoryTask
        : Optional[zio.aws.fsx.model.DataRepositoryTask.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataRepositoryTask())
        .map(value => zio.aws.fsx.model.DataRepositoryTask.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateDataRepositoryTaskResponse
  ): zio.aws.fsx.model.CreateDataRepositoryTaskResponse.ReadOnly = new Wrapper(
    impl
  )
}
