package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  Megabytes,
  DailyTime,
  AutomaticBackupRetentionDays,
  PerUnitStorageThroughput,
  WeeklyTime,
  Flag,
  ArchivePath
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateFileSystemLustreConfiguration(
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    importPath: Optional[ArchivePath] = Optional.Absent,
    exportPath: Optional[ArchivePath] = Optional.Absent,
    importedFileChunkSize: Optional[Megabytes] = Optional.Absent,
    deploymentType: Optional[zio.aws.fsx.model.LustreDeploymentType] =
      Optional.Absent,
    autoImportPolicy: Optional[zio.aws.fsx.model.AutoImportPolicyType] =
      Optional.Absent,
    perUnitStorageThroughput: Optional[PerUnitStorageThroughput] =
      Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    copyTagsToBackups: Optional[Flag] = Optional.Absent,
    driveCacheType: Optional[zio.aws.fsx.model.DriveCacheType] =
      Optional.Absent,
    dataCompressionType: Optional[zio.aws.fsx.model.DataCompressionType] =
      Optional.Absent,
    logConfiguration: Optional[zio.aws.fsx.model.LustreLogCreateConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemLustreConfiguration = {
    import CreateFileSystemLustreConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemLustreConfiguration
      .builder()
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        importPath.map(value => ArchivePath.unwrap(value): java.lang.String)
      )(_.importPath)
      .optionallyWith(
        exportPath.map(value => ArchivePath.unwrap(value): java.lang.String)
      )(_.exportPath)
      .optionallyWith(
        importedFileChunkSize.map(value => Megabytes.unwrap(value): Integer)
      )(_.importedFileChunkSize)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(autoImportPolicy.map(value => value.unwrap))(
        _.autoImportPolicy
      )
      .optionallyWith(
        perUnitStorageThroughput.map(value =>
          PerUnitStorageThroughput.unwrap(value): Integer
        )
      )(_.perUnitStorageThroughput)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(driveCacheType.map(value => value.unwrap))(
        _.driveCacheType
      )
      .optionallyWith(dataCompressionType.map(value => value.unwrap))(
        _.dataCompressionType
      )
      .optionallyWith(logConfiguration.map(value => value.buildAwsValue()))(
        _.logConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemLustreConfiguration.wrap(buildAwsValue())
}
object CreateFileSystemLustreConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemLustreConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemLustreConfiguration =
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration(
        weeklyMaintenanceStartTime.map(value => value),
        importPath.map(value => value),
        exportPath.map(value => value),
        importedFileChunkSize.map(value => value),
        deploymentType.map(value => value),
        autoImportPolicy.map(value => value),
        perUnitStorageThroughput.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        driveCacheType.map(value => value),
        dataCompressionType.map(value => value),
        logConfiguration.map(value => value.asEditable)
      )
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def importPath: Optional[ArchivePath]
    def exportPath: Optional[ArchivePath]
    def importedFileChunkSize: Optional[Megabytes]
    def deploymentType: Optional[zio.aws.fsx.model.LustreDeploymentType]
    def autoImportPolicy: Optional[zio.aws.fsx.model.AutoImportPolicyType]
    def perUnitStorageThroughput: Optional[PerUnitStorageThroughput]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Optional[Flag]
    def driveCacheType: Optional[zio.aws.fsx.model.DriveCacheType]
    def dataCompressionType: Optional[zio.aws.fsx.model.DataCompressionType]
    def logConfiguration
        : Optional[zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly]
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getImportPath: ZIO[Any, AwsError, ArchivePath] =
      AwsError.unwrapOptionField("importPath", importPath)
    def getExportPath: ZIO[Any, AwsError, ArchivePath] =
      AwsError.unwrapOptionField("exportPath", exportPath)
    def getImportedFileChunkSize: ZIO[Any, AwsError, Megabytes] =
      AwsError.unwrapOptionField("importedFileChunkSize", importedFileChunkSize)
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.LustreDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getAutoImportPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.AutoImportPolicyType] =
      AwsError.unwrapOptionField("autoImportPolicy", autoImportPolicy)
    def getPerUnitStorageThroughput
        : ZIO[Any, AwsError, PerUnitStorageThroughput] = AwsError
      .unwrapOptionField("perUnitStorageThroughput", perUnitStorageThroughput)
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getDriveCacheType
        : ZIO[Any, AwsError, zio.aws.fsx.model.DriveCacheType] =
      AwsError.unwrapOptionField("driveCacheType", driveCacheType)
    def getDataCompressionType
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataCompressionType] =
      AwsError.unwrapOptionField("dataCompressionType", dataCompressionType)
    def getLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("logConfiguration", logConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemLustreConfiguration
  ) extends zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly {
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val importPath: Optional[ArchivePath] = zio.aws.core.internal
      .optionalFromNullable(impl.importPath())
      .map(value => zio.aws.fsx.model.primitives.ArchivePath(value))
    override val exportPath: Optional[ArchivePath] = zio.aws.core.internal
      .optionalFromNullable(impl.exportPath())
      .map(value => zio.aws.fsx.model.primitives.ArchivePath(value))
    override val importedFileChunkSize: Optional[Megabytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedFileChunkSize())
        .map(value => zio.aws.fsx.model.primitives.Megabytes(value))
    override val deploymentType
        : Optional[zio.aws.fsx.model.LustreDeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value => zio.aws.fsx.model.LustreDeploymentType.wrap(value))
    override val autoImportPolicy
        : Optional[zio.aws.fsx.model.AutoImportPolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoImportPolicy())
        .map(value => zio.aws.fsx.model.AutoImportPolicyType.wrap(value))
    override val perUnitStorageThroughput: Optional[PerUnitStorageThroughput] =
      zio.aws.core.internal
        .optionalFromNullable(impl.perUnitStorageThroughput())
        .map(value =>
          zio.aws.fsx.model.primitives.PerUnitStorageThroughput(value)
        )
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val driveCacheType: Optional[zio.aws.fsx.model.DriveCacheType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.driveCacheType())
        .map(value => zio.aws.fsx.model.DriveCacheType.wrap(value))
    override val dataCompressionType
        : Optional[zio.aws.fsx.model.DataCompressionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCompressionType())
        .map(value => zio.aws.fsx.model.DataCompressionType.wrap(value))
    override val logConfiguration
        : Optional[zio.aws.fsx.model.LustreLogCreateConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logConfiguration())
        .map(value =>
          zio.aws.fsx.model.LustreLogCreateConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemLustreConfiguration
  ): zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly =
    new Wrapper(impl)
}
