package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  SubnetId,
  SecurityGroupId,
  FileSystemTypeVersion,
  ClientRequestToken,
  StorageCapacity,
  KmsKeyId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateFileSystemRequest(
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    fileSystemType: zio.aws.fsx.model.FileSystemType,
    storageCapacity: StorageCapacity,
    storageType: Optional[zio.aws.fsx.model.StorageType] = Optional.Absent,
    subnetIds: Iterable[SubnetId],
    securityGroupIds: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent,
    windowsConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration
    ] = Optional.Absent,
    lustreConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration
    ] = Optional.Absent,
    ontapConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemOntapConfiguration
    ] = Optional.Absent,
    fileSystemTypeVersion: Optional[FileSystemTypeVersion] = Optional.Absent,
    openZFSConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest = {
    import CreateFileSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .fileSystemType(fileSystemType.unwrap)
      .storageCapacity(StorageCapacity.unwrap(storageCapacity): Integer)
      .optionallyWith(storageType.map(value => value.unwrap))(_.storageType)
      .subnetIds(subnetIds.map { item =>
        SubnetId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        securityGroupIds.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroupIds)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .optionallyWith(windowsConfiguration.map(value => value.buildAwsValue()))(
        _.windowsConfiguration
      )
      .optionallyWith(lustreConfiguration.map(value => value.buildAwsValue()))(
        _.lustreConfiguration
      )
      .optionallyWith(ontapConfiguration.map(value => value.buildAwsValue()))(
        _.ontapConfiguration
      )
      .optionallyWith(
        fileSystemTypeVersion.map(value =>
          FileSystemTypeVersion.unwrap(value): java.lang.String
        )
      )(_.fileSystemTypeVersion)
      .optionallyWith(openZFSConfiguration.map(value => value.buildAwsValue()))(
        _.openZFSConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateFileSystemRequest.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemRequest.wrap(buildAwsValue())
}
object CreateFileSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemRequest =
      zio.aws.fsx.model.CreateFileSystemRequest(
        clientRequestToken.map(value => value),
        fileSystemType,
        storageCapacity,
        storageType.map(value => value),
        subnetIds,
        securityGroupIds.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        windowsConfiguration.map(value => value.asEditable),
        lustreConfiguration.map(value => value.asEditable),
        ontapConfiguration.map(value => value.asEditable),
        fileSystemTypeVersion.map(value => value),
        openZFSConfiguration.map(value => value.asEditable)
      )
    def clientRequestToken: Optional[ClientRequestToken]
    def fileSystemType: zio.aws.fsx.model.FileSystemType
    def storageCapacity: StorageCapacity
    def storageType: Optional[zio.aws.fsx.model.StorageType]
    def subnetIds: List[SubnetId]
    def securityGroupIds: Optional[List[SecurityGroupId]]
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def kmsKeyId: Optional[KmsKeyId]
    def windowsConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly
    ]
    def lustreConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly
    ]
    def ontapConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemOntapConfiguration.ReadOnly
    ]
    def fileSystemTypeVersion: Optional[FileSystemTypeVersion]
    def openZFSConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly
    ]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getFileSystemType: ZIO[Any, Nothing, zio.aws.fsx.model.FileSystemType] =
      ZIO.succeed(fileSystemType)
    def getStorageCapacity: ZIO[Any, Nothing, StorageCapacity] =
      ZIO.succeed(storageCapacity)
    def getStorageType: ZIO[Any, AwsError, zio.aws.fsx.model.StorageType] =
      AwsError.unwrapOptionField("storageType", storageType)
    def getSubnetIds: ZIO[Any, Nothing, List[SubnetId]] = ZIO.succeed(subnetIds)
    def getSecurityGroupIds: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroupIds", securityGroupIds)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getWindowsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("windowsConfiguration", windowsConfiguration)
    def getLustreConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("lustreConfiguration", lustreConfiguration)
    def getOntapConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemOntapConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("ontapConfiguration", ontapConfiguration)
    def getFileSystemTypeVersion: ZIO[Any, AwsError, FileSystemTypeVersion] =
      AwsError.unwrapOptionField("fileSystemTypeVersion", fileSystemTypeVersion)
    def getOpenZFSConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("openZFSConfiguration", openZFSConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest
  ) extends zio.aws.fsx.model.CreateFileSystemRequest.ReadOnly {
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val fileSystemType: zio.aws.fsx.model.FileSystemType =
      zio.aws.fsx.model.FileSystemType.wrap(impl.fileSystemType())
    override val storageCapacity: StorageCapacity =
      zio.aws.fsx.model.primitives.StorageCapacity(impl.storageCapacity())
    override val storageType: Optional[zio.aws.fsx.model.StorageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageType())
        .map(value => zio.aws.fsx.model.StorageType.wrap(value))
    override val subnetIds: List[SubnetId] = impl
      .subnetIds()
      .asScala
      .map { item =>
        zio.aws.fsx.model.primitives.SubnetId(item)
      }
      .toList
    override val securityGroupIds: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroupIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.fsx.model.primitives.KmsKeyId(value))
    override val windowsConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.windowsConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.wrap(value)
      )
    override val lustreConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemLustreConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lustreConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemLustreConfiguration.wrap(value)
      )
    override val ontapConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemOntapConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.ontapConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemOntapConfiguration.wrap(value)
      )
    override val fileSystemTypeVersion: Optional[FileSystemTypeVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystemTypeVersion())
        .map(value => zio.aws.fsx.model.primitives.FileSystemTypeVersion(value))
    override val openZFSConfiguration: Optional[
      zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.openZFSConfiguration())
      .map(value =>
        zio.aws.fsx.model.CreateFileSystemOpenZFSConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemRequest
  ): zio.aws.fsx.model.CreateFileSystemRequest.ReadOnly = new Wrapper(impl)
}
