package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateFileSystemResponse(
    fileSystem: Optional[zio.aws.fsx.model.FileSystem] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemResponse = {
    import CreateFileSystemResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemResponse
      .builder()
      .optionallyWith(fileSystem.map(value => value.buildAwsValue()))(
        _.fileSystem
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateFileSystemResponse.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemResponse.wrap(buildAwsValue())
}
object CreateFileSystemResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemResponse =
      zio.aws.fsx.model
        .CreateFileSystemResponse(fileSystem.map(value => value.asEditable))
    def fileSystem: Optional[zio.aws.fsx.model.FileSystem.ReadOnly]
    def getFileSystem
        : ZIO[Any, AwsError, zio.aws.fsx.model.FileSystem.ReadOnly] =
      AwsError.unwrapOptionField("fileSystem", fileSystem)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemResponse
  ) extends zio.aws.fsx.model.CreateFileSystemResponse.ReadOnly {
    override val fileSystem: Optional[zio.aws.fsx.model.FileSystem.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileSystem())
        .map(value => zio.aws.fsx.model.FileSystem.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemResponse
  ): zio.aws.fsx.model.CreateFileSystemResponse.ReadOnly = new Wrapper(impl)
}
