package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  SubnetId,
  AlternateDNSName,
  DailyTime,
  MegabytesPerSecond,
  AutomaticBackupRetentionDays,
  WeeklyTime,
  Flag,
  DirectoryId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateFileSystemWindowsConfiguration(
    activeDirectoryId: Optional[DirectoryId] = Optional.Absent,
    selfManagedActiveDirectoryConfiguration: Optional[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration
    ] = Optional.Absent,
    deploymentType: Optional[zio.aws.fsx.model.WindowsDeploymentType] =
      Optional.Absent,
    preferredSubnetId: Optional[SubnetId] = Optional.Absent,
    throughputCapacity: MegabytesPerSecond,
    weeklyMaintenanceStartTime: Optional[WeeklyTime] = Optional.Absent,
    dailyAutomaticBackupStartTime: Optional[DailyTime] = Optional.Absent,
    automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays] =
      Optional.Absent,
    copyTagsToBackups: Optional[Flag] = Optional.Absent,
    aliases: Optional[Iterable[AlternateDNSName]] = Optional.Absent,
    auditLogConfiguration: Optional[
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration = {
    import CreateFileSystemWindowsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration
      .builder()
      .optionallyWith(
        activeDirectoryId.map(value =>
          DirectoryId.unwrap(value): java.lang.String
        )
      )(_.activeDirectoryId)
      .optionallyWith(
        selfManagedActiveDirectoryConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.selfManagedActiveDirectoryConfiguration)
      .optionallyWith(deploymentType.map(value => value.unwrap))(
        _.deploymentType
      )
      .optionallyWith(
        preferredSubnetId.map(value => SubnetId.unwrap(value): java.lang.String)
      )(_.preferredSubnetId)
      .throughputCapacity(
        MegabytesPerSecond.unwrap(throughputCapacity): Integer
      )
      .optionallyWith(
        weeklyMaintenanceStartTime.map(value =>
          WeeklyTime.unwrap(value): java.lang.String
        )
      )(_.weeklyMaintenanceStartTime)
      .optionallyWith(
        dailyAutomaticBackupStartTime.map(value =>
          DailyTime.unwrap(value): java.lang.String
        )
      )(_.dailyAutomaticBackupStartTime)
      .optionallyWith(
        automaticBackupRetentionDays.map(value =>
          AutomaticBackupRetentionDays.unwrap(value): Integer
        )
      )(_.automaticBackupRetentionDays)
      .optionallyWith(
        copyTagsToBackups.map(value => Flag.unwrap(value): java.lang.Boolean)
      )(_.copyTagsToBackups)
      .optionallyWith(
        aliases.map(value =>
          value.map { item =>
            AlternateDNSName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.aliases)
      .optionallyWith(
        auditLogConfiguration.map(value => value.buildAwsValue())
      )(_.auditLogConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.wrap(buildAwsValue())
}
object CreateFileSystemWindowsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateFileSystemWindowsConfiguration =
      zio.aws.fsx.model.CreateFileSystemWindowsConfiguration(
        activeDirectoryId.map(value => value),
        selfManagedActiveDirectoryConfiguration.map(value => value.asEditable),
        deploymentType.map(value => value),
        preferredSubnetId.map(value => value),
        throughputCapacity,
        weeklyMaintenanceStartTime.map(value => value),
        dailyAutomaticBackupStartTime.map(value => value),
        automaticBackupRetentionDays.map(value => value),
        copyTagsToBackups.map(value => value),
        aliases.map(value => value),
        auditLogConfiguration.map(value => value.asEditable)
      )
    def activeDirectoryId: Optional[DirectoryId]
    def selfManagedActiveDirectoryConfiguration: Optional[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly
    ]
    def deploymentType: Optional[zio.aws.fsx.model.WindowsDeploymentType]
    def preferredSubnetId: Optional[SubnetId]
    def throughputCapacity: MegabytesPerSecond
    def weeklyMaintenanceStartTime: Optional[WeeklyTime]
    def dailyAutomaticBackupStartTime: Optional[DailyTime]
    def automaticBackupRetentionDays: Optional[AutomaticBackupRetentionDays]
    def copyTagsToBackups: Optional[Flag]
    def aliases: Optional[List[AlternateDNSName]]
    def auditLogConfiguration: Optional[
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly
    ]
    def getActiveDirectoryId: ZIO[Any, AwsError, DirectoryId] =
      AwsError.unwrapOptionField("activeDirectoryId", activeDirectoryId)
    def getSelfManagedActiveDirectoryConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "selfManagedActiveDirectoryConfiguration",
      selfManagedActiveDirectoryConfiguration
    )
    def getDeploymentType
        : ZIO[Any, AwsError, zio.aws.fsx.model.WindowsDeploymentType] =
      AwsError.unwrapOptionField("deploymentType", deploymentType)
    def getPreferredSubnetId: ZIO[Any, AwsError, SubnetId] =
      AwsError.unwrapOptionField("preferredSubnetId", preferredSubnetId)
    def getThroughputCapacity: ZIO[Any, Nothing, MegabytesPerSecond] =
      ZIO.succeed(throughputCapacity)
    def getWeeklyMaintenanceStartTime: ZIO[Any, AwsError, WeeklyTime] =
      AwsError.unwrapOptionField(
        "weeklyMaintenanceStartTime",
        weeklyMaintenanceStartTime
      )
    def getDailyAutomaticBackupStartTime: ZIO[Any, AwsError, DailyTime] =
      AwsError.unwrapOptionField(
        "dailyAutomaticBackupStartTime",
        dailyAutomaticBackupStartTime
      )
    def getAutomaticBackupRetentionDays
        : ZIO[Any, AwsError, AutomaticBackupRetentionDays] =
      AwsError.unwrapOptionField(
        "automaticBackupRetentionDays",
        automaticBackupRetentionDays
      )
    def getCopyTagsToBackups: ZIO[Any, AwsError, Flag] =
      AwsError.unwrapOptionField("copyTagsToBackups", copyTagsToBackups)
    def getAliases: ZIO[Any, AwsError, List[AlternateDNSName]] =
      AwsError.unwrapOptionField("aliases", aliases)
    def getAuditLogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("auditLogConfiguration", auditLogConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration
  ) extends zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly {
    override val activeDirectoryId: Optional[DirectoryId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activeDirectoryId())
        .map(value => zio.aws.fsx.model.primitives.DirectoryId(value))
    override val selfManagedActiveDirectoryConfiguration: Optional[
      zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.selfManagedActiveDirectoryConfiguration())
      .map(value =>
        zio.aws.fsx.model.SelfManagedActiveDirectoryConfiguration.wrap(value)
      )
    override val deploymentType
        : Optional[zio.aws.fsx.model.WindowsDeploymentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentType())
        .map(value => zio.aws.fsx.model.WindowsDeploymentType.wrap(value))
    override val preferredSubnetId: Optional[SubnetId] = zio.aws.core.internal
      .optionalFromNullable(impl.preferredSubnetId())
      .map(value => zio.aws.fsx.model.primitives.SubnetId(value))
    override val throughputCapacity: MegabytesPerSecond =
      zio.aws.fsx.model.primitives.MegabytesPerSecond(impl.throughputCapacity())
    override val weeklyMaintenanceStartTime: Optional[WeeklyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.weeklyMaintenanceStartTime())
        .map(value => zio.aws.fsx.model.primitives.WeeklyTime(value))
    override val dailyAutomaticBackupStartTime: Optional[DailyTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dailyAutomaticBackupStartTime())
        .map(value => zio.aws.fsx.model.primitives.DailyTime(value))
    override val automaticBackupRetentionDays
        : Optional[AutomaticBackupRetentionDays] = zio.aws.core.internal
      .optionalFromNullable(impl.automaticBackupRetentionDays())
      .map(value =>
        zio.aws.fsx.model.primitives.AutomaticBackupRetentionDays(value)
      )
    override val copyTagsToBackups: Optional[Flag] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTagsToBackups())
      .map(value => zio.aws.fsx.model.primitives.Flag(value))
    override val aliases: Optional[List[AlternateDNSName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aliases())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.primitives.AlternateDNSName(item)
          }.toList
        )
    override val auditLogConfiguration: Optional[
      zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.auditLogConfiguration())
      .map(value =>
        zio.aws.fsx.model.WindowsAuditLogCreateConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateFileSystemWindowsConfiguration
  ): zio.aws.fsx.model.CreateFileSystemWindowsConfiguration.ReadOnly =
    new Wrapper(impl)
}
