package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  StorageVirtualMachineId,
  Flag,
  VolumeCapacity,
  JunctionPath
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateOntapVolumeConfiguration(
    junctionPath: JunctionPath,
    securityStyle: Optional[zio.aws.fsx.model.SecurityStyle] = Optional.Absent,
    sizeInMegabytes: VolumeCapacity,
    storageEfficiencyEnabled: Flag,
    storageVirtualMachineId: StorageVirtualMachineId,
    tieringPolicy: Optional[zio.aws.fsx.model.TieringPolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration = {
    import CreateOntapVolumeConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration
      .builder()
      .junctionPath(JunctionPath.unwrap(junctionPath): java.lang.String)
      .optionallyWith(securityStyle.map(value => value.unwrap))(_.securityStyle)
      .sizeInMegabytes(VolumeCapacity.unwrap(sizeInMegabytes): Integer)
      .storageEfficiencyEnabled(
        Flag.unwrap(storageEfficiencyEnabled): java.lang.Boolean
      )
      .storageVirtualMachineId(
        StorageVirtualMachineId.unwrap(
          storageVirtualMachineId
        ): java.lang.String
      )
      .optionallyWith(tieringPolicy.map(value => value.buildAwsValue()))(
        _.tieringPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateOntapVolumeConfiguration.wrap(buildAwsValue())
}
object CreateOntapVolumeConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateOntapVolumeConfiguration =
      zio.aws.fsx.model.CreateOntapVolumeConfiguration(
        junctionPath,
        securityStyle.map(value => value),
        sizeInMegabytes,
        storageEfficiencyEnabled,
        storageVirtualMachineId,
        tieringPolicy.map(value => value.asEditable)
      )
    def junctionPath: JunctionPath
    def securityStyle: Optional[zio.aws.fsx.model.SecurityStyle]
    def sizeInMegabytes: VolumeCapacity
    def storageEfficiencyEnabled: Flag
    def storageVirtualMachineId: StorageVirtualMachineId
    def tieringPolicy: Optional[zio.aws.fsx.model.TieringPolicy.ReadOnly]
    def getJunctionPath: ZIO[Any, Nothing, JunctionPath] =
      ZIO.succeed(junctionPath)
    def getSecurityStyle: ZIO[Any, AwsError, zio.aws.fsx.model.SecurityStyle] =
      AwsError.unwrapOptionField("securityStyle", securityStyle)
    def getSizeInMegabytes: ZIO[Any, Nothing, VolumeCapacity] =
      ZIO.succeed(sizeInMegabytes)
    def getStorageEfficiencyEnabled: ZIO[Any, Nothing, Flag] =
      ZIO.succeed(storageEfficiencyEnabled)
    def getStorageVirtualMachineId: ZIO[Any, Nothing, StorageVirtualMachineId] =
      ZIO.succeed(storageVirtualMachineId)
    def getTieringPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      AwsError.unwrapOptionField("tieringPolicy", tieringPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration
  ) extends zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly {
    override val junctionPath: JunctionPath =
      zio.aws.fsx.model.primitives.JunctionPath(impl.junctionPath())
    override val securityStyle: Optional[zio.aws.fsx.model.SecurityStyle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityStyle())
        .map(value => zio.aws.fsx.model.SecurityStyle.wrap(value))
    override val sizeInMegabytes: VolumeCapacity =
      zio.aws.fsx.model.primitives.VolumeCapacity(impl.sizeInMegabytes())
    override val storageEfficiencyEnabled: Flag =
      zio.aws.fsx.model.primitives.Flag(impl.storageEfficiencyEnabled())
    override val storageVirtualMachineId: StorageVirtualMachineId =
      zio.aws.fsx.model.primitives
        .StorageVirtualMachineId(impl.storageVirtualMachineId())
    override val tieringPolicy
        : Optional[zio.aws.fsx.model.TieringPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tieringPolicy())
        .map(value => zio.aws.fsx.model.TieringPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateOntapVolumeConfiguration
  ): zio.aws.fsx.model.CreateOntapVolumeConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
