package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.fsx.model.primitives.ResourceARN
import scala.jdk.CollectionConverters.*
final case class CreateOpenZFSOriginSnapshotConfiguration(
    snapshotARN: ResourceARN,
    copyStrategy: zio.aws.fsx.model.OpenZFSCopyStrategy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateOpenZFSOriginSnapshotConfiguration = {
    import CreateOpenZFSOriginSnapshotConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateOpenZFSOriginSnapshotConfiguration
      .builder()
      .snapshotARN(ResourceARN.unwrap(snapshotARN): java.lang.String)
      .copyStrategy(copyStrategy.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration.ReadOnly =
    zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration
      .wrap(buildAwsValue())
}
object CreateOpenZFSOriginSnapshotConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateOpenZFSOriginSnapshotConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration =
      zio.aws.fsx.model
        .CreateOpenZFSOriginSnapshotConfiguration(snapshotARN, copyStrategy)
    def snapshotARN: ResourceARN
    def copyStrategy: zio.aws.fsx.model.OpenZFSCopyStrategy
    def getSnapshotARN: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(snapshotARN)
    def getCopyStrategy
        : ZIO[Any, Nothing, zio.aws.fsx.model.OpenZFSCopyStrategy] =
      ZIO.succeed(copyStrategy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateOpenZFSOriginSnapshotConfiguration
  ) extends zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration.ReadOnly {
    override val snapshotARN: ResourceARN =
      zio.aws.fsx.model.primitives.ResourceARN(impl.snapshotARN())
    override val copyStrategy: zio.aws.fsx.model.OpenZFSCopyStrategy =
      zio.aws.fsx.model.OpenZFSCopyStrategy.wrap(impl.copyStrategy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateOpenZFSOriginSnapshotConfiguration
  ): zio.aws.fsx.model.CreateOpenZFSOriginSnapshotConfiguration.ReadOnly =
    new Wrapper(impl)
}
