package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.{VolumeId, SnapshotName, ClientRequestToken}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSnapshotRequest(
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    name: SnapshotName,
    volumeId: VolumeId,
    tags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateSnapshotRequest = {
    import CreateSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateSnapshotRequest
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .name(SnapshotName.unwrap(name): java.lang.String)
      .volumeId(VolumeId.unwrap(volumeId): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateSnapshotRequest.ReadOnly =
    zio.aws.fsx.model.CreateSnapshotRequest.wrap(buildAwsValue())
}
object CreateSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateSnapshotRequest =
      zio.aws.fsx.model.CreateSnapshotRequest(
        clientRequestToken.map(value => value),
        name,
        volumeId,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientRequestToken: Optional[ClientRequestToken]
    def name: SnapshotName
    def volumeId: VolumeId
    def tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getName: ZIO[Any, Nothing, SnapshotName] = ZIO.succeed(name)
    def getVolumeId: ZIO[Any, Nothing, VolumeId] = ZIO.succeed(volumeId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateSnapshotRequest
  ) extends zio.aws.fsx.model.CreateSnapshotRequest.ReadOnly {
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value => zio.aws.fsx.model.primitives.ClientRequestToken(value))
    override val name: SnapshotName =
      zio.aws.fsx.model.primitives.SnapshotName(impl.name())
    override val volumeId: VolumeId =
      zio.aws.fsx.model.primitives.VolumeId(impl.volumeId())
    override val tags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateSnapshotRequest
  ): zio.aws.fsx.model.CreateSnapshotRequest.ReadOnly = new Wrapper(impl)
}
