package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateSnapshotResponse(
    snapshot: Optional[zio.aws.fsx.model.Snapshot] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse = {
    import CreateSnapshotResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse
      .builder()
      .optionallyWith(snapshot.map(value => value.buildAwsValue()))(_.snapshot)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly =
    zio.aws.fsx.model.CreateSnapshotResponse.wrap(buildAwsValue())
}
object CreateSnapshotResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateSnapshotResponse = zio.aws.fsx.model
      .CreateSnapshotResponse(snapshot.map(value => value.asEditable))
    def snapshot: Optional[zio.aws.fsx.model.Snapshot.ReadOnly]
    def getSnapshot: ZIO[Any, AwsError, zio.aws.fsx.model.Snapshot.ReadOnly] =
      AwsError.unwrapOptionField("snapshot", snapshot)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse
  ) extends zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly {
    override val snapshot: Optional[zio.aws.fsx.model.Snapshot.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snapshot())
        .map(value => zio.aws.fsx.model.Snapshot.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateSnapshotResponse
  ): zio.aws.fsx.model.CreateSnapshotResponse.ReadOnly = new Wrapper(impl)
}
