package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateStorageVirtualMachineResponse(
    storageVirtualMachine: Optional[zio.aws.fsx.model.StorageVirtualMachine] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineResponse = {
    import CreateStorageVirtualMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineResponse
      .builder()
      .optionallyWith(
        storageVirtualMachine.map(value => value.buildAwsValue())
      )(_.storageVirtualMachine)
      .build()
  }
  def asReadOnly
      : zio.aws.fsx.model.CreateStorageVirtualMachineResponse.ReadOnly =
    zio.aws.fsx.model.CreateStorageVirtualMachineResponse.wrap(buildAwsValue())
}
object CreateStorageVirtualMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.CreateStorageVirtualMachineResponse =
      zio.aws.fsx.model.CreateStorageVirtualMachineResponse(
        storageVirtualMachine.map(value => value.asEditable)
      )
    def storageVirtualMachine
        : Optional[zio.aws.fsx.model.StorageVirtualMachine.ReadOnly]
    def getStorageVirtualMachine
        : ZIO[Any, AwsError, zio.aws.fsx.model.StorageVirtualMachine.ReadOnly] =
      AwsError.unwrapOptionField("storageVirtualMachine", storageVirtualMachine)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineResponse
  ) extends zio.aws.fsx.model.CreateStorageVirtualMachineResponse.ReadOnly {
    override val storageVirtualMachine
        : Optional[zio.aws.fsx.model.StorageVirtualMachine.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageVirtualMachine())
        .map(value => zio.aws.fsx.model.StorageVirtualMachine.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.CreateStorageVirtualMachineResponse
  ): zio.aws.fsx.model.CreateStorageVirtualMachineResponse.ReadOnly =
    new Wrapper(impl)
}
