package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{Megabytes, ArchivePath}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DataRepositoryConfiguration(
    lifecycle: Optional[zio.aws.fsx.model.DataRepositoryLifecycle] =
      Optional.Absent,
    importPath: Optional[ArchivePath] = Optional.Absent,
    exportPath: Optional[ArchivePath] = Optional.Absent,
    importedFileChunkSize: Optional[Megabytes] = Optional.Absent,
    autoImportPolicy: Optional[zio.aws.fsx.model.AutoImportPolicyType] =
      Optional.Absent,
    failureDetails: Optional[zio.aws.fsx.model.DataRepositoryFailureDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DataRepositoryConfiguration = {
    import DataRepositoryConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DataRepositoryConfiguration
      .builder()
      .optionallyWith(lifecycle.map(value => value.unwrap))(_.lifecycle)
      .optionallyWith(
        importPath.map(value => ArchivePath.unwrap(value): java.lang.String)
      )(_.importPath)
      .optionallyWith(
        exportPath.map(value => ArchivePath.unwrap(value): java.lang.String)
      )(_.exportPath)
      .optionallyWith(
        importedFileChunkSize.map(value => Megabytes.unwrap(value): Integer)
      )(_.importedFileChunkSize)
      .optionallyWith(autoImportPolicy.map(value => value.unwrap))(
        _.autoImportPolicy
      )
      .optionallyWith(failureDetails.map(value => value.buildAwsValue()))(
        _.failureDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DataRepositoryConfiguration.ReadOnly =
    zio.aws.fsx.model.DataRepositoryConfiguration.wrap(buildAwsValue())
}
object DataRepositoryConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DataRepositoryConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DataRepositoryConfiguration =
      zio.aws.fsx.model.DataRepositoryConfiguration(
        lifecycle.map(value => value),
        importPath.map(value => value),
        exportPath.map(value => value),
        importedFileChunkSize.map(value => value),
        autoImportPolicy.map(value => value),
        failureDetails.map(value => value.asEditable)
      )
    def lifecycle: Optional[zio.aws.fsx.model.DataRepositoryLifecycle]
    def importPath: Optional[ArchivePath]
    def exportPath: Optional[ArchivePath]
    def importedFileChunkSize: Optional[Megabytes]
    def autoImportPolicy: Optional[zio.aws.fsx.model.AutoImportPolicyType]
    def failureDetails
        : Optional[zio.aws.fsx.model.DataRepositoryFailureDetails.ReadOnly]
    def getLifecycle
        : ZIO[Any, AwsError, zio.aws.fsx.model.DataRepositoryLifecycle] =
      AwsError.unwrapOptionField("lifecycle", lifecycle)
    def getImportPath: ZIO[Any, AwsError, ArchivePath] =
      AwsError.unwrapOptionField("importPath", importPath)
    def getExportPath: ZIO[Any, AwsError, ArchivePath] =
      AwsError.unwrapOptionField("exportPath", exportPath)
    def getImportedFileChunkSize: ZIO[Any, AwsError, Megabytes] =
      AwsError.unwrapOptionField("importedFileChunkSize", importedFileChunkSize)
    def getAutoImportPolicy
        : ZIO[Any, AwsError, zio.aws.fsx.model.AutoImportPolicyType] =
      AwsError.unwrapOptionField("autoImportPolicy", autoImportPolicy)
    def getFailureDetails: ZIO[
      Any,
      AwsError,
      zio.aws.fsx.model.DataRepositoryFailureDetails.ReadOnly
    ] = AwsError.unwrapOptionField("failureDetails", failureDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryConfiguration
  ) extends zio.aws.fsx.model.DataRepositoryConfiguration.ReadOnly {
    override val lifecycle
        : Optional[zio.aws.fsx.model.DataRepositoryLifecycle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lifecycle())
        .map(value => zio.aws.fsx.model.DataRepositoryLifecycle.wrap(value))
    override val importPath: Optional[ArchivePath] = zio.aws.core.internal
      .optionalFromNullable(impl.importPath())
      .map(value => zio.aws.fsx.model.primitives.ArchivePath(value))
    override val exportPath: Optional[ArchivePath] = zio.aws.core.internal
      .optionalFromNullable(impl.exportPath())
      .map(value => zio.aws.fsx.model.primitives.ArchivePath(value))
    override val importedFileChunkSize: Optional[Megabytes] =
      zio.aws.core.internal
        .optionalFromNullable(impl.importedFileChunkSize())
        .map(value => zio.aws.fsx.model.primitives.Megabytes(value))
    override val autoImportPolicy
        : Optional[zio.aws.fsx.model.AutoImportPolicyType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoImportPolicy())
        .map(value => zio.aws.fsx.model.AutoImportPolicyType.wrap(value))
    override val failureDetails
        : Optional[zio.aws.fsx.model.DataRepositoryFailureDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureDetails())
        .map(value =>
          zio.aws.fsx.model.DataRepositoryFailureDetails.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryConfiguration
  ): zio.aws.fsx.model.DataRepositoryConfiguration.ReadOnly = new Wrapper(impl)
}
