package zio.aws.fsx.model
import scala.jdk.CollectionConverters.*
sealed trait DataRepositoryLifecycle {
  def unwrap: software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle
}
object DataRepositoryLifecycle {
  def wrap(
      value: software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle
  ): zio.aws.fsx.model.DataRepositoryLifecycle = value match {
    case software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.MISCONFIGURED =>
      val r = MISCONFIGURED
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.fsx.model.DataRepositoryLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.fsx.model.DataRepositoryLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.CREATING
  }
  case object AVAILABLE extends zio.aws.fsx.model.DataRepositoryLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.AVAILABLE
  }
  case object MISCONFIGURED extends zio.aws.fsx.model.DataRepositoryLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.MISCONFIGURED
  }
  case object UPDATING extends zio.aws.fsx.model.DataRepositoryLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.UPDATING
  }
  case object DELETING extends zio.aws.fsx.model.DataRepositoryLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.DELETING
  }
  case object FAILED extends zio.aws.fsx.model.DataRepositoryLifecycle {
    override def unwrap
        : software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle =
      software.amazon.awssdk.services.fsx.model.DataRepositoryLifecycle.FAILED
  }
}
