package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.ErrorMessage
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DataRepositoryTaskFailureDetails(
    message: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFailureDetails = {
    import DataRepositoryTaskFailureDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFailureDetails
      .builder()
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DataRepositoryTaskFailureDetails.ReadOnly =
    zio.aws.fsx.model.DataRepositoryTaskFailureDetails.wrap(buildAwsValue())
}
object DataRepositoryTaskFailureDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFailureDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DataRepositoryTaskFailureDetails =
      zio.aws.fsx.model
        .DataRepositoryTaskFailureDetails(message.map(value => value))
    def message: Optional[ErrorMessage]
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFailureDetails
  ) extends zio.aws.fsx.model.DataRepositoryTaskFailureDetails.ReadOnly {
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.fsx.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskFailureDetails
  ): zio.aws.fsx.model.DataRepositoryTaskFailureDetails.ReadOnly = new Wrapper(
    impl
  )
}
