package zio.aws.fsx.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{
  LastUpdatedTime,
  FailedCount,
  SucceededCount,
  TotalCount
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DataRepositoryTaskStatus(
    totalCount: Optional[TotalCount] = Optional.Absent,
    succeededCount: Optional[SucceededCount] = Optional.Absent,
    failedCount: Optional[FailedCount] = Optional.Absent,
    lastUpdatedTime: Optional[LastUpdatedTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DataRepositoryTaskStatus = {
    import DataRepositoryTaskStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DataRepositoryTaskStatus
      .builder()
      .optionallyWith(
        totalCount.map(value => TotalCount.unwrap(value): java.lang.Long)
      )(_.totalCount)
      .optionallyWith(
        succeededCount.map(value =>
          SucceededCount.unwrap(value): java.lang.Long
        )
      )(_.succeededCount)
      .optionallyWith(
        failedCount.map(value => FailedCount.unwrap(value): java.lang.Long)
      )(_.failedCount)
      .optionallyWith(
        lastUpdatedTime.map(value => LastUpdatedTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DataRepositoryTaskStatus.ReadOnly =
    zio.aws.fsx.model.DataRepositoryTaskStatus.wrap(buildAwsValue())
}
object DataRepositoryTaskStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DataRepositoryTaskStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DataRepositoryTaskStatus =
      zio.aws.fsx.model.DataRepositoryTaskStatus(
        totalCount.map(value => value),
        succeededCount.map(value => value),
        failedCount.map(value => value),
        lastUpdatedTime.map(value => value)
      )
    def totalCount: Optional[TotalCount]
    def succeededCount: Optional[SucceededCount]
    def failedCount: Optional[FailedCount]
    def lastUpdatedTime: Optional[LastUpdatedTime]
    def getTotalCount: ZIO[Any, AwsError, TotalCount] =
      AwsError.unwrapOptionField("totalCount", totalCount)
    def getSucceededCount: ZIO[Any, AwsError, SucceededCount] =
      AwsError.unwrapOptionField("succeededCount", succeededCount)
    def getFailedCount: ZIO[Any, AwsError, FailedCount] =
      AwsError.unwrapOptionField("failedCount", failedCount)
    def getLastUpdatedTime: ZIO[Any, AwsError, LastUpdatedTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskStatus
  ) extends zio.aws.fsx.model.DataRepositoryTaskStatus.ReadOnly {
    override val totalCount: Optional[TotalCount] = zio.aws.core.internal
      .optionalFromNullable(impl.totalCount())
      .map(value => zio.aws.fsx.model.primitives.TotalCount(value))
    override val succeededCount: Optional[SucceededCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.succeededCount())
        .map(value => zio.aws.fsx.model.primitives.SucceededCount(value))
    override val failedCount: Optional[FailedCount] = zio.aws.core.internal
      .optionalFromNullable(impl.failedCount())
      .map(value => zio.aws.fsx.model.primitives.FailedCount(value))
    override val lastUpdatedTime: Optional[LastUpdatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value => zio.aws.fsx.model.primitives.LastUpdatedTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DataRepositoryTaskStatus
  ): zio.aws.fsx.model.DataRepositoryTaskStatus.ReadOnly = new Wrapper(impl)
}
