package zio.aws.fsx.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.fsx.model.primitives.BackupId
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteFileSystemOpenZFSResponse(
    finalBackupId: Optional[BackupId] = Optional.Absent,
    finalBackupTags: Optional[Iterable[zio.aws.fsx.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSResponse = {
    import DeleteFileSystemOpenZFSResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSResponse
      .builder()
      .optionallyWith(
        finalBackupId.map(value => BackupId.unwrap(value): java.lang.String)
      )(_.finalBackupId)
      .optionallyWith(
        finalBackupTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.finalBackupTags)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.ReadOnly =
    zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.wrap(buildAwsValue())
}
object DeleteFileSystemOpenZFSResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse =
      zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse(
        finalBackupId.map(value => value),
        finalBackupTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def finalBackupId: Optional[BackupId]
    def finalBackupTags: Optional[List[zio.aws.fsx.model.Tag.ReadOnly]]
    def getFinalBackupId: ZIO[Any, AwsError, BackupId] =
      AwsError.unwrapOptionField("finalBackupId", finalBackupId)
    def getFinalBackupTags
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("finalBackupTags", finalBackupTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSResponse
  ) extends zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.ReadOnly {
    override val finalBackupId: Optional[BackupId] = zio.aws.core.internal
      .optionalFromNullable(impl.finalBackupId())
      .map(value => zio.aws.fsx.model.primitives.BackupId(value))
    override val finalBackupTags
        : Optional[List[zio.aws.fsx.model.Tag.ReadOnly]] = zio.aws.core.internal
      .optionalFromNullable(impl.finalBackupTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DeleteFileSystemOpenZFSResponse
  ): zio.aws.fsx.model.DeleteFileSystemOpenZFSResponse.ReadOnly = new Wrapper(
    impl
  )
}
