package zio.aws.fsx.model
import zio.prelude.data.Optional
import zio.aws.fsx.model.primitives.{NextToken, MaxResults, BackupId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeBackupsRequest(
    backupIds: Optional[Iterable[BackupId]] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.fsx.model.Filter]] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest = {
    import DescribeBackupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest
      .builder()
      .optionallyWith(
        backupIds.map(value =>
          value.map { item =>
            BackupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.backupIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.fsx.model.DescribeBackupsRequest.ReadOnly =
    zio.aws.fsx.model.DescribeBackupsRequest.wrap(buildAwsValue())
}
object DescribeBackupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.fsx.model.DescribeBackupsRequest =
      zio.aws.fsx.model.DescribeBackupsRequest(
        backupIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def backupIds: Optional[List[BackupId]]
    def filters: Optional[List[zio.aws.fsx.model.Filter.ReadOnly]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getBackupIds: ZIO[Any, AwsError, List[BackupId]] =
      AwsError.unwrapOptionField("backupIds", backupIds)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.fsx.model.Filter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest
  ) extends zio.aws.fsx.model.DescribeBackupsRequest.ReadOnly {
    override val backupIds: Optional[List[BackupId]] = zio.aws.core.internal
      .optionalFromNullable(impl.backupIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.fsx.model.primitives.BackupId(item)
        }.toList
      )
    override val filters: Optional[List[zio.aws.fsx.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.fsx.model.Filter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.fsx.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.fsx.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.fsx.model.DescribeBackupsRequest
  ): zio.aws.fsx.model.DescribeBackupsRequest.ReadOnly = new Wrapper(impl)
}
